/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.database.core.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.entry.TccLock;
import top.dogtcc.database.core.annotation.DogDb;
import top.dogtcc.database.core.annotation.DogTable;
import top.dogtcc.database.core.annotation.OperationType;
import top.dogtcc.database.core.annotation.QueryArg;
import top.dogtcc.database.core.aop.DBLockBuilder;
import top.dogtcc.database.core.aop.DataContainer;
import top.dogtcc.database.core.aop.ParameterType;
import top.dogtcc.database.core.util.ReflectUtil;

class DogAopHelper {
    private static Logger logger = Logger.getLogger(DogAopHelper.class);
    private ParameterType parameterType;
    private int parameterLength;
    private OperationType operationType;
    private ProceedingJoinPoint pjp;
    private Annotation[][] annotations;
    private DogDb db;
    private Class<?> clazz;

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    private int getMethodParameterLength(ParameterType parameterType, ProceedingJoinPoint joinPoint) throws IllegalArgumentException, IllegalAccessException {
        if (parameterType.equals((Object)ParameterType.NoParameter)) {
            return 0;
        }
        if (parameterType.equals((Object)ParameterType.QueryArgs)) {
            int length = 0;
            Annotation[][] annotationArray = this.annotations;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                    if (!(annotation instanceof QueryArg)) continue;
                    ++length;
                }
            }
            return length;
        }
        if (parameterType.equals((Object)ParameterType.OneDogTable)) {
            return ReflectUtil.getFields(joinPoint.getArgs()[0], DogTable.class, QueryArg.class).size();
        }
        if (parameterType.equals((Object)ParameterType.OneIterableOfDogTable)) {
            Object object = ((Iterable)joinPoint.getArgs()[0]).iterator().next();
            return ReflectUtil.getFields(object, DogTable.class, QueryArg.class).size();
        }
        return -1;
    }

    private ParameterType getParameterType(ProceedingJoinPoint joinPoint) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object[] args = joinPoint.getArgs();
        if (args.length == 0) {
            return ParameterType.NoParameter;
        }
        Annotation[][] annotationArray = this.annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                if (!(annotation instanceof QueryArg)) continue;
                return ParameterType.QueryArgs;
            }
        }
        if (args.length == 1) {
            Object firstParameter = args[0];
            if (firstParameter.getClass().getAnnotation(DogTable.class) != null) {
                return ParameterType.OneDogTable;
            }
            if (ReflectUtil.iterable(firstParameter)) {
                Object obj;
                Iterator iterator = ((Iterable)firstParameter).iterator();
                if (iterator.hasNext() && (obj = iterator.next()).getClass().getAnnotation(DogTable.class) != null) {
                    return ParameterType.OneIterableOfDogTable;
                }
                return ParameterType.OneEmptyIterable;
            }
        }
        throw new IllegalArgumentException();
    }

    public Method getMethod() throws NoSuchMethodException, IllegalArgumentException {
        String methodName = "";
        if (this.db.operationType().equals(OperationType.INSERTNEWDATA)) {
            methodName = this.db.deleteMethodName();
        } else if (this.db.operationType().equals(OperationType.UPDATEDATA)) {
            methodName = this.db.queryMethodName();
        }
        if (!this.parameterType.equals((Object)ParameterType.OneEmptyIterable)) {
            List<Method> methods = ReflectUtil.getMethods(this.clazz, methodName, this.parameterLength);
            if (methods.size() == 0) {
                throw new NoSuchMethodException(methodName);
            }
            return methods.get(0);
        }
        return null;
    }

    public DogAopHelper(ProceedingJoinPoint pjp, DogDb db, Class<?> clazz) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.annotations = ReflectUtil.getParameterAnnotations(pjp);
        this.parameterType = this.getParameterType(pjp);
        this.operationType = db.operationType();
        this.parameterLength = this.getMethodParameterLength(this.parameterType, pjp);
        this.db = db;
        this.pjp = pjp;
        this.clazz = clazz;
        logger.info((Object)("parameterType:" + (Object)((Object)this.parameterType) + "   parameterLength:" + this.parameterLength + " operationType:" + this.operationType));
    }

    DataContainer getDataLoader() throws IllegalArgumentException {
        if (this.parameterType.equals((Object)ParameterType.NoParameter) || this.parameterType.equals((Object)ParameterType.OneEmptyIterable)) {
            return new DataContainer(){

                @Override
                public Iterator<Pair<TccLock, List<Object>>> iterator() {
                    return new ArrayList().iterator();
                }
            };
        }
        if (this.parameterType.equals((Object)ParameterType.QueryArgs)) {
            return new DataContainer(){

                @Override
                public Iterator<Pair<TccLock, List<Object>>> iterator() {
                    ArrayList<Pair> arrayList = new ArrayList<Pair>();
                    Pair queryArg = ReflectUtil.getAnnotationedParameter(DogAopHelper.this.pjp.getArgs(), DogAopHelper.this.annotations, QueryArg.class);
                    TccLock tccLock = new DBLockBuilder().setDogDb(DogAopHelper.this.db).setQueryArgs((List)queryArg.getKey()).build((List)queryArg.getValue());
                    arrayList.add(new Pair((Object)tccLock, queryArg.getValue()));
                    return arrayList.iterator();
                }
            };
        }
        if (this.parameterType.equals((Object)ParameterType.OneDogTable)) {
            return new DataContainer(){

                @Override
                public Iterator<Pair<TccLock, List<Object>>> iterator() {
                    ArrayList<Pair> arrayList = new ArrayList<Pair>();
                    try {
                        DogTable dogTable = DogAopHelper.this.pjp.getArgs()[0].getClass().getAnnotation(DogTable.class);
                        Pair fields = ReflectUtil.getAnnotationedFields(DogAopHelper.this.pjp.getArgs()[0].getClass(), QueryArg.class);
                        List<Object> objects = ReflectUtil.getFieldsValues(DogAopHelper.this.pjp.getArgs()[0], (List)fields.getValue());
                        TccLock tccLock = new DBLockBuilder().setDogDb(DogAopHelper.this.db).setDogTable(dogTable).setQueryArgs((List)fields.getKey()).build(objects);
                        arrayList.add(new Pair((Object)tccLock, objects));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return arrayList.iterator();
                }
            };
        }
        if (this.parameterType.equals((Object)ParameterType.OneIterableOfDogTable)) {
            return new DataContainer(){

                @Override
                public Iterator<Pair<TccLock, List<Object>>> iterator() {
                    ArrayList<Pair> arrayList = new ArrayList<Pair>();
                    try {
                        Object firstObj = ((Iterable)DogAopHelper.this.pjp.getArgs()[0]).iterator().next();
                        DogTable dogTable = firstObj.getClass().getAnnotation(DogTable.class);
                        Pair fields = ReflectUtil.getAnnotationedFields(firstObj.getClass(), QueryArg.class);
                        Iterator iterator = ((Iterable)DogAopHelper.this.pjp.getArgs()[0]).iterator();
                        while (iterator.hasNext()) {
                            List<Object> objects = ReflectUtil.getFieldsValues(iterator.next(), (List)fields.getValue());
                            TccLock tccLock = new DBLockBuilder().setDogDb(DogAopHelper.this.db).setDogTable(dogTable).setQueryArgs((List)fields.getKey()).build(objects);
                            arrayList.add(new Pair((Object)tccLock, objects));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return arrayList.iterator();
                }
            };
        }
        throw new IllegalArgumentException();
    }
}

