/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.database.core.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.common.ThreadManager;
import top.dogtcc.core.entry.TccLock;
import top.dogtcc.core.jms.ILockPool;
import top.dogtcc.database.core.ClazzInfo;
import top.dogtcc.database.core.annotation.DogDb;
import top.dogtcc.database.core.annotation.OperationType;
import top.dogtcc.database.core.aop.DataContainer;
import top.dogtcc.database.core.aop.DogAopHelper;
import top.dogtcc.database.core.buffer.IDataBuffer;
import top.dogtcc.database.core.util.ReflectUtil;

@Component
@Aspect
public class DogDbAop {
    private static Logger logger = Logger.getLogger(DogDbAop.class);
    @Autowired
    ILockPool iLockPool;
    @Autowired
    IDataBuffer buffer;

    private void saveLockersInContext(DogDb db, Set<TccLock> newLocks, Class<?> clazz) {
        ClazzInfo clazzInfo;
        Map context = ThreadManager.getContext().getContext();
        if (context.containsKey(clazzInfo = ClazzInfo.createClazzInfo(db, clazz))) {
            Set values = (Set)context.get(clazzInfo);
            values.addAll(newLocks);
        } else {
            context.put(clazzInfo, newLocks);
        }
    }

    @Around(value="@annotation(top.dogtcc.database.core.annotation.DogDb)  && @annotation(db)")
    public Object doAroundtransaction(ProceedingJoinPoint pjp, DogDb db) throws Throwable {
        Object result = null;
        if (!ThreadManager.inTcc()) {
            result = pjp.proceed();
            return result;
        }
        Set newLocks = null;
        DogAopHelper aopHelper = new DogAopHelper(pjp, db, ReflectUtil.getTargetClass(pjp));
        OperationType operationType = db.operationType();
        DataContainer factory = aopHelper.getDataLoader();
        Iterator iterator = factory.iterator();
        Method method = aopHelper.getMethod();
        if (method != null) {
            logger.info((Object)("repository methodName: " + method.getName()));
        }
        HashMap<Object, Object> lockedData = new HashMap<Object, Object>();
        try {
            Object values;
            if (ThreadManager.inTcc() && operationType.equals(OperationType.UPDATEDATA)) {
                if (method != null) {
                    if (Iterable.class.isAssignableFrom(method.getReturnType())) {
                        throw new UnsupportedOperationException(method.getName());
                    }
                    while (iterator.hasNext()) {
                        values = (Pair)iterator.next();
                        Object queryData = method.invoke(ReflectUtil.getTarget(pjp), ((List)values.getValue()).toArray());
                        if (queryData == null) continue;
                        if (Optional.class.isAssignableFrom(queryData.getClass())) {
                            if (!((Optional)queryData).isPresent()) continue;
                            lockedData.put(values.getKey(), ((Optional)queryData).get());
                            continue;
                        }
                        lockedData.put(values.getKey(), queryData);
                    }
                }
            } else if (ThreadManager.inTcc() && operationType.equals(OperationType.INSERTNEWDATA) && method != null) {
                while (iterator.hasNext()) {
                    values = (Pair)iterator.next();
                    lockedData.put(values.getKey(), ((List)values.getValue()).toArray());
                }
            }
            if (lockedData.size() != 0) {
                newLocks = this.iLockPool.lock(ThreadManager.currentTcc(), ThreadManager.currentCall(), lockedData.keySet());
                for (TccLock lock : newLocks) {
                    logger.info((Object)("Locks: " + lock.getKey()));
                    this.buffer.buffData(lock, lockedData.get(lock));
                }
                this.saveLockersInContext(db, newLocks, ReflectUtil.getTargetClass(pjp));
            }
            result = pjp.proceed();
        }
        catch (Exception e) {
            if (newLocks != null) {
                for (TccLock lock : newLocks) {
                    this.buffer.clearData(lock);
                }
            }
            throw e;
        }
        return result;
    }
}

