/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.database.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.util.SpringContextUtil;

public class ReflectUtil {
    public static <T extends Annotation> Pair<List<T>, List<Field>> getAnnotationedFields(Class<?> clazz, Class<? extends Annotation> annotationClazz) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Annotation> queryArgs = new ArrayList<Annotation>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            Annotation queryArg = field.getAnnotation(annotationClazz);
            if (queryArg == null) continue;
            field.setAccessible(true);
            queryArgs.add(queryArg);
            fields.add(field);
        }
        return new Pair(queryArgs, fields);
    }

    public static List<Object> getFieldsValues(Object obj, List<Field> fields) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : fields) {
            values.add(field.get(obj));
        }
        return values;
    }

    public static <T extends Annotation> Pair<List<T>, List<Object>> getAnnotationedParameter(Object[] args, Annotation[][] annotations, Class<? extends Annotation> clazz) {
        ArrayList<Annotation> queryArgs = new ArrayList<Annotation>();
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < args.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!annotation.annotationType().equals(clazz)) continue;
                queryArgs.add(annotation);
                objects.add(args[i]);
            }
        }
        return new Pair(queryArgs, objects);
    }

    public static Annotation[][] getParameterAnnotations(ProceedingJoinPoint pjp) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        MethodInvocationProceedingJoinPoint methodJoinPoint = (MethodInvocationProceedingJoinPoint)pjp;
        Field methodInvocationfield = methodJoinPoint.getClass().getDeclaredField("methodInvocation");
        methodInvocationfield.setAccessible(true);
        Annotation[][] argAnnotations = ((ReflectiveMethodInvocation)methodInvocationfield.get(methodJoinPoint)).getMethod().getParameterAnnotations();
        return argAnnotations;
    }

    public static boolean iterable(Object object) {
        return Iterable.class.isAssignableFrom(object.getClass());
    }

    public static List<Object> getFields(Object object, Class<? extends Annotation> clazzAnnotationClazz, Class<? extends Annotation> fieldAnnotationClazz) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Object> argObjs = new ArrayList<Object>();
        if (object.getClass().getAnnotation(clazzAnnotationClazz) != null) {
            for (Field field : object.getClass().getDeclaredFields()) {
                Annotation fieldAnnotation = field.getAnnotation(fieldAnnotationClazz);
                if (fieldAnnotation == null) continue;
                field.setAccessible(true);
                argObjs.add(field.get(object));
            }
        }
        return argObjs;
    }

    public static boolean allIterable(Class<?>[] clazzs) {
        for (Class<?> clazz : clazzs) {
            if (Iterable.class.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneIterable(Class<?>[] clazzs) {
        for (Class<?> clazz : clazzs) {
            if (!Iterable.class.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodStr) throws NoSuchMethodException {
        Method[] fullMethod = new Method[clazz.getMethods().length + clazz.getDeclaredMethods().length];
        System.arraycopy(clazz.getMethods(), 0, fullMethod, 0, clazz.getMethods().length);
        System.arraycopy(clazz.getDeclaredMethods(), 0, fullMethod, clazz.getMethods().length, clazz.getDeclaredMethods().length);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodStr)) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(methodStr);
    }

    public static List<Method> getMethods(Class<?> clazz, String methodStr) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] fullMethod = new Method[clazz.getMethods().length + clazz.getDeclaredMethods().length];
        System.arraycopy(clazz.getMethods(), 0, fullMethod, 0, clazz.getMethods().length);
        System.arraycopy(clazz.getDeclaredMethods(), 0, fullMethod, clazz.getMethods().length, clazz.getDeclaredMethods().length);
        for (Method method : fullMethod) {
            if (!method.getName().equals(methodStr)) continue;
            method.setAccessible(true);
            methods.add(method);
        }
        return methods;
    }

    public static List<Method> getMethods(Class<?> clazz, String methodStr, int parameterNum) throws NoSuchMethodException {
        List<Method> methods = ReflectUtil.getMethods(clazz, methodStr);
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getParameters().length != parameterNum) continue;
            filteredMethods.add(method);
        }
        return filteredMethods;
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    public static Object getTarget(ProceedingJoinPoint pjp) throws ClassNotFoundException {
        return SpringContextUtil.getApplicationContext().getBean(Class.forName(pjp.getThis().getClass().getName().split("\\$")[0]));
    }

    public static Class<?> getTargetClass(ProceedingJoinPoint pjp) throws ClassNotFoundException {
        return Class.forName(pjp.getThis().getClass().getName().split("\\$")[0]);
    }
}

