/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import java.lang.reflect.ParameterizedType;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import top.ibase4j.core.base.AbstractController;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.BaseService;
import top.ibase4j.core.support.Pagination;
import top.ibase4j.core.support.context.ApplicationContextHolder;
import top.ibase4j.core.util.ThreadUtil;

public abstract class BaseController<T extends BaseModel, S extends BaseService<T>>
extends AbstractController
implements InitializingBean {
    protected S service;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
            Class cls = (Class)type.getActualTypeArguments()[1];
            try {
                this.service = (BaseService)ApplicationContextHolder.getService(cls);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                ThreadUtil.sleep(1, 5);
                this.afterPropertiesSet();
            }
        }
        super.afterPropertiesSet();
    }

    public Object query(Map<String, Object> param) {
        return this.query(new ModelMap(), param);
    }

    public Object query(ModelMap modelMap, Map<String, Object> param) {
        if (param.get("keyword") == null && param.get("search") != null) {
            param.put("keyword", param.get("search"));
            param.remove("search");
        }
        Pagination page = this.service.query(param);
        return this.setSuccessModelMap(modelMap, page);
    }

    public Object queryList(Map<String, Object> param) {
        return this.queryList(new ModelMap(), param);
    }

    public Object queryList(ModelMap modelMap, Map<String, Object> param) {
        List<Map<String, Object>> list = this.service.queryList(param);
        return this.setSuccessModelMap(modelMap, list);
    }

    public Object get(BaseModel param) {
        return this.get(new ModelMap(), param);
    }

    public Object get(ModelMap modelMap, BaseModel param) {
        Object result = this.service.queryById(param.getId());
        return this.setSuccessModelMap(modelMap, result);
    }

    public Object update(T param) {
        return this.update(new ModelMap(), param);
    }

    public Object update(ModelMap modelMap, T param) {
        Long userId = this.getCurrUser().getId();
        if (((BaseModel)param).getId() == null) {
            ((BaseModel)param).setCreateBy(userId);
            ((BaseModel)param).setCreateTime(new Date());
        }
        ((BaseModel)param).setUpdateBy(userId);
        ((BaseModel)param).setUpdateTime(new Date());
        T result = this.service.update(param);
        ((BaseModel)param).setId(((BaseModel)result).getId());
        return this.setSuccessModelMap(modelMap);
    }

    public Object delete(T param) {
        return this.delete(new ModelMap(), param);
    }

    public Object delete(ModelMap modelMap, T param) {
        Assert.notNull((Object)((BaseModel)param).getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.service.delete(((BaseModel)param).getId());
        return this.setSuccessModelMap(modelMap);
    }

    public Object del(HttpServletRequest request, T param) {
        return this.del(new ModelMap(), request, param);
    }

    public Object del(ModelMap modelMap, HttpServletRequest request, T param) {
        if (((BaseModel)param).getId() != null) {
            Assert.notNull((Object)((BaseModel)param).getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.service.del(((BaseModel)param).getId(), this.getCurrUser(request));
        }
        if (((BaseModel)param).getIds() != null) {
            Assert.notNull(((BaseModel)param).getIds(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.service.del(((BaseModel)param).getIds(), this.getCurrUser(request));
        }
        return this.setSuccessModelMap(modelMap);
    }
}

