/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.DateUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class CsrfFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private List<String> whiteUrls;
    private int size = 0;

    public void init(FilterConfig filterConfig) {
        this.logger.info("init CsrfFilter..");
        String path = CsrfFilter.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/csrfWhite.txt");
        this.size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            String url = req.getRequestURL().toString();
            String referurl = req.getHeader("Referer");
            if (!this.isWhiteRequest(referurl)) {
                this.logger.warn("\u8de8\u7ad9\u8bf7\u6c42---->>>{} || {} || {} || {}", (Object)url, (Object)referurl, (Object)WebUtil.getHost(req), (Object)DateUtil.getDateTime());
                WebUtil.write(response, 308, "\u9519\u8bef\u7684\u8bf7\u6c42\u5934\u4fe1\u606f");
                return;
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.logger.error("doFilter", (Throwable)e);
        }
    }

    private boolean isWhiteRequest(String referUrl) {
        if (referUrl == null || "".equals(referUrl.trim()) || this.size == 0) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        String refHost = referUrl.toLowerCase();
        for (String urlTemp : this.whiteUrls) {
            if (!refHost.startsWith(urlTemp.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.logger.info("destroy CsrfFilter.");
    }
}

