/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class BaseInterceptor
extends HandlerInterceptorAdapter {
    protected static final Logger logger = LogManager.getLogger();
    private BaseInterceptor[] nextInterceptor;

    public void setNextInterceptor(BaseInterceptor ... nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.nextInterceptor == null) {
            return true;
        }
        for (int i = 0; i < this.nextInterceptor.length; ++i) {
            if (this.nextInterceptor[i].preHandle(request, response, handler)) continue;
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.nextInterceptor != null) {
            for (BaseInterceptor element : this.nextInterceptor) {
                element.postHandle(request, response, handler, modelAndView);
            }
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.nextInterceptor != null) {
            for (BaseInterceptor element : this.nextInterceptor) {
                element.afterCompletion(request, response, handler, ex);
            }
        }
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.nextInterceptor != null) {
            for (BaseInterceptor element : this.nextInterceptor) {
                element.afterConcurrentHandlingStarted(request, response, handler);
            }
        }
    }
}

