/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.method.HandlerMethod;
import top.ibase4j.core.interceptor.BaseInterceptor;
import top.ibase4j.core.support.context.ApplicationContextHolder;
import top.ibase4j.core.support.http.SessionUser;
import top.ibase4j.core.util.DateUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.ThreadUtil;
import top.ibase4j.core.util.WebUtil;
import top.ibase4j.model.SysEvent;
import top.ibase4j.service.SysEventService;

public class EventInterceptor
extends BaseInterceptor {
    private final ThreadLocal<Long> STARTTIME_THREADLOCAL = new NamedThreadLocal("ThreadLocalStartTime");
    private SysEventService sysEventService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getServletPath();
        this.STARTTIME_THREADLOCAL.set(System.currentTimeMillis());
        Map<String, Object> params = WebUtil.getParameterMap(request);
        logger.info("request {} parameters===>{}", (Object)path, (Object)JSON.toJSONString(params));
        WebUtil.REQUEST.set(request);
        return super.preHandle(request, response, handler);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, final Exception ex) throws Exception {
        String path;
        Long endTime;
        Long startTime;
        block14: {
            startTime = this.STARTTIME_THREADLOCAL.get();
            endTime = System.currentTimeMillis();
            path = request.getServletPath();
            if (handler instanceof HandlerMethod) {
                try {
                    String userAgent = request.getHeader("USER-AGENT");
                    String clientIp = WebUtil.getHost(request);
                    SessionUser session = WebUtil.getCurrentUser(request);
                    if (!(path.contains("/error") || path.contains("/read/") || path.contains("/get") || path.contains("/query") || path.contains("/detail") || path.contains("/unauthorized") || path.contains("/forbidden"))) {
                        final SysEvent record = new SysEvent();
                        record.setMethod(request.getMethod());
                        record.setRequestUri(path);
                        record.setClientHost(clientIp);
                        record.setUserAgent(userAgent);
                        if (path.contains("/upload")) {
                            record.setParameters("");
                        } else {
                            record.setParameters(JSON.toJSONString(WebUtil.getParameter(request)));
                        }
                        record.setStatus(response.getStatus());
                        if (session != null) {
                            record.setUserName(session.getUserName());
                            record.setUserPhone(session.getUserPhone());
                            record.setCreateBy(session.getId());
                            record.setUpdateBy(session.getId());
                        }
                        final String msg = (String)request.getAttribute("msg");
                        try {
                            HandlerMethod handlerMethod = (HandlerMethod)handler;
                            ApiOperation apiOperation = handlerMethod.getMethod().getAnnotation(ApiOperation.class);
                            if (apiOperation != null) {
                                record.setTitle(apiOperation.value());
                            }
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                        }
                        ThreadUtil.execute("sysEventLog", 10, 60, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                                        record.setRemark(msg);
                                    } else {
                                        record.setRemark(ExceptionUtil.getStackTraceAsString(ex));
                                    }
                                    EventInterceptor.this.saveEvent(record);
                                }
                                catch (Exception e) {
                                    BaseInterceptor.logger.error("Save event log cause error :", (Throwable)e);
                                }
                            }
                        });
                        break block14;
                    }
                    if (path.contains("/unauthorized")) {
                        logger.warn("The user [{}] no login", (Object)(clientIp + "@" + userAgent));
                    } else if (path.contains("/forbidden")) {
                        logger.warn("The user [{}] no promission", (Object)(JSON.toJSONString((Object)session) + "@" + clientIp + "@" + userAgent));
                    } else {
                        logger.info(JSON.toJSONString((Object)session) + "@" + path + "@" + clientIp + userAgent);
                    }
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
            }
        }
        String message = "Starttime: {}; Endtime: {}; Used time: {}s; URI: {}; ";
        logger.debug(message, (Object)DateUtil.format(startTime, "HH:mm:ss.SSS"), (Object)DateUtil.format(endTime, "HH:mm:ss.SSS"), (Object)String.valueOf((double)(endTime - startTime) / 1000.0), (Object)path);
        super.afterCompletion(request, response, handler, ex);
    }

    protected void saveEvent(SysEvent record) {
        if (this.sysEventService == null) {
            this.sysEventService = ApplicationContextHolder.getService(SysEventService.class);
        }
        this.sysEventService.update(record);
    }
}

