/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import top.ibase4j.core.support.http.HttpCode;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class SignInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LogManager.getLogger();
    private List<String> whiteUrls;
    private int size = 0;

    public SignInterceptor() {
        String path = SignInterceptor.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/signWhite.txt");
        this.size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = request.getRequestURL().toString();
        String refer = request.getHeader("Referer");
        if (refer != null && refer.contains("/swagger")) {
            logger.info("SignInterceptor skip");
            return true;
        }
        if (WebUtil.isWhiteRequest(url, this.size, this.whiteUrls)) {
            logger.info("SignInterceptor skip");
            return true;
        }
        String sign = request.getHeader("sign");
        if (DataUtil.isEmpty(sign)) {
            return WebUtil.write((ServletResponse)response, HttpCode.NOT_ACCEPTABLE.value(), "\u8bf7\u6c42\u53c2\u6570\u672a\u7b7e\u540d");
        }
        String timestamp = request.getHeader("timestamp");
        if (DataUtil.isEmpty(timestamp)) {
            return WebUtil.write((ServletResponse)response, HttpCode.NOT_ACCEPTABLE.value(), "\u8bf7\u6c42\u65e0\u6548");
        }
        logger.info("timestamp={}", (Object)timestamp);
        if (Math.abs(System.currentTimeMillis() - Long.valueOf(timestamp)) > 300000L) {
            return WebUtil.write((ServletResponse)response, HttpCode.FORBIDDEN.value(), "\u8bf7\u6c42\u5df2\u8fc7\u671f");
        }
        Map<String, Object> params = WebUtil.getParameterMap(request);
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp=").append(timestamp);
        for (Object key : keys) {
            if ("dataFile".equals(key)) continue;
            sb.append("&").append((String)key).append("=").append(params.get(key));
        }
        String encrypt = DigestUtils.md5Hex((String)URLEncoder.encode(sb.toString(), "UTF-8"));
        if (!encrypt.toLowerCase().equals(sign.toLowerCase())) {
            logger.warn("sign={} \u9519\u8bef\uff0c \u6b63\u786esign= {}", (Object)sign, (Object)encrypt);
            return WebUtil.write((ServletResponse)response, HttpCode.FORBIDDEN.value(), "\u7b7e\u540d\u9519\u8bef");
        }
        logger.info("SignInterceptor successful");
        return true;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String encrypt = DigestUtils.md5Hex((String)URLEncoder.encode("timestamp=1551017726066", "UTF-8"));
        System.out.println(encrypt);
    }
}

