/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import top.ibase4j.core.support.context.Resources;
import top.ibase4j.core.util.IDCardUtil;

public abstract class Assert {
    private static String getMessage(String key, Object ... args) {
        return Resources.getMessage(key, args);
    }

    public static void isTrue(boolean expression, String key) {
        if (!expression) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void isNull(Object object, String key) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void notNull(Object object, String key, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_IS_NULL", args));
        }
    }

    public static void hasLength(String text, String key) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void hasText(String text, String key) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String key) {
        if (StringUtils.isNotBlank((CharSequence)textToSearch) && StringUtils.isNotBlank((CharSequence)substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void notEmpty(Object[] array, String key, Object ... args) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_IS_EMPTY", args));
        }
    }

    public static void noNullElements(Object[] array, String key) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
            }
        }
    }

    public static void notEmpty(Collection<?> collection, String key) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void notEmpty(Map<?, ?> map, String key) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String key) {
        Assert.notNull(type, key, new Object[0]);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String key) {
        Assert.notNull(superType, key, new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void isBlank(String text, String key) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            throw new IllegalArgumentException(Assert.getMessage(key, new Object[0]));
        }
    }

    public static void isNotBlank(String text, String key) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_IS_NULL", new Object[0]));
        }
    }

    public static void min(Integer value, Integer min, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value < min) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MIN", min));
        }
    }

    public static void max(Integer value, Integer max, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value > max) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MAX", max));
        }
    }

    public static void range(Integer value, Integer min, Integer max, String key) {
        Assert.min(value, min, key);
        Assert.max(value, max, key);
    }

    public static void min(Float value, Float min, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value.floatValue() < min.floatValue()) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MIN", min));
        }
    }

    public static void max(Float value, Float max, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value.floatValue() > max.floatValue()) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MAX", max));
        }
    }

    public static void range(Float value, Float min, Float max, String key) {
        Assert.min(value, min, key);
        Assert.max(value, max, key);
    }

    public static void min(Double value, Double min, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value < min) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MIN", min));
        }
    }

    public static void max(Double value, Double max, String key) {
        Assert.notNull(value, key, new Object[0]);
        if (value > max) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_MAX", max));
        }
    }

    public static void range(Double value, Double min, Double max, String key) {
        Assert.min(value, min, key);
        Assert.max(value, max, key);
    }

    public static void length(String text, Integer min, Integer max, String key) {
        Assert.notNull(text, key, new Object[0]);
        if (min != null && text.length() < min) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_LENGTH", min, max));
        }
        if (max != null && text.length() > max) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_LENGTH", min, max));
        }
    }

    public static void future(Date date, String key) {
        if (date != null && date.compareTo(new Date()) <= 0) {
            throw new IllegalArgumentException(Assert.getMessage(key + "_NOT_FUTURE", new Object[0]));
        }
    }

    public static void idCard(String text) {
        if (!IDCardUtil.isIdentity(text)) {
            throw new IllegalArgumentException(Assert.getMessage("IDCARD_ILLEGAL", new Object[0]));
        }
    }

    public static void email(String text) {
        String regex = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Assert.pattern(text, regex, true, "EMAIL");
    }

    public static void mobile(String text) {
        String regex = "((^(13|15|17|18)[0-9]{9}$)|(^0[1,2]{1}\\d{1}-?\\d{8}$)|(^0[3-9] {1}\\d{2}-?\\d{7,8}$)|(^0[1,2]{1}\\d{1}-?\\d{8}-(\\d{1,4})$)|(^0[3-9]{1}\\d{2}-? \\d{7,8}-(\\d{1,4})$))";
        Assert.pattern(text, regex, true, "MOBILE");
    }

    public static void pattern(String text, String regex, boolean flag, String key) {
        boolean result = false;
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            result = matcher.matches();
        }
        catch (Exception e) {
            result = false;
        }
        if (result != flag) {
            throw new IllegalArgumentException(text + "->" + Assert.getMessage(key + "_ILLEGAL", new Object[0]));
        }
    }
}

