/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RScript;
import org.redisson.api.RType;
import org.redisson.api.RedissonClient;
import top.ibase4j.core.support.cache.CacheManager;
import top.ibase4j.core.support.redisson.Client;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public class RedissonHelper
implements CacheManager {
    private RedissonClient redissonClient;
    private final Integer EXPIRE = PropertiesUtil.getInt("redis.expiration");

    public void setClient(Client client) {
        this.redissonClient = client.getRedissonClient();
        CacheUtil.setLockManager(this);
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
        CacheUtil.setLockManager(this);
    }

    private RBucket<Object> getRedisBucket(String key) {
        return this.redissonClient.getBucket(key);
    }

    @Override
    public final Object get(String key) {
        RBucket<Object> temp = this.getRedisBucket(key);
        return temp.get();
    }

    @Override
    public Object get(String key, Integer expire) {
        RBucket<Object> temp = this.getRedisBucket(key);
        this.expire(temp, (int)expire);
        return temp.get();
    }

    @Override
    public Object getFire(String key) {
        RBucket<Object> temp = this.getRedisBucket(key);
        this.expire(temp, (int)this.EXPIRE);
        return temp.get();
    }

    @Override
    public final void set(String key, Serializable value) {
        RBucket<Object> temp = this.getRedisBucket(key);
        temp.set((Object)value);
        this.expire(temp, (int)this.EXPIRE);
    }

    @Override
    public final void set(String key, Serializable value, int seconds) {
        RBucket<Object> temp = this.getRedisBucket(key);
        temp.set((Object)value);
        this.expire(temp, seconds);
    }

    public final void multiSet(Map<String, Object> temps) {
        this.redissonClient.getBuckets().set(temps);
    }

    @Override
    public final Boolean exists(String key) {
        RBucket<Object> temp = this.getRedisBucket(key);
        return temp.isExists();
    }

    @Override
    public final void del(String key) {
        this.redissonClient.getKeys().delete(new String[]{key});
    }

    @Override
    public final void delAll(String pattern) {
        this.redissonClient.getKeys().deleteByPattern(pattern);
    }

    @Override
    public final String type(String key) {
        RType type = this.redissonClient.getKeys().getType(key);
        if (type == null) {
            return null;
        }
        return type.getClass().getName();
    }

    private final void expire(RBucket<Object> bucket, int seconds) {
        bucket.expire((long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public final Boolean expireAt(String key, long unixTime) {
        return this.redissonClient.getBucket(key).expireAt(new Date(unixTime));
    }

    @Override
    public final Long ttl(String key) {
        RBucket<Object> rBucket = this.getRedisBucket(key);
        return rBucket.remainTimeToLive();
    }

    @Override
    public final Object getSet(String key, Serializable value) {
        RBucket<Object> rBucket = this.getRedisBucket(key);
        return rBucket.getAndSet((Object)value);
    }

    @Override
    public Set<Object> getAll(String pattern) {
        HashSet<Object> set = InstanceUtil.newHashSet();
        Iterable keys = this.redissonClient.getKeys().getKeysByPattern(pattern);
        for (String key : keys) {
            set.add(this.getRedisBucket(key).get());
        }
        return set;
    }

    @Override
    public Set<Object> getAll(String pattern, Integer expire) {
        HashSet<Object> set = InstanceUtil.newHashSet();
        Iterable keys = this.redissonClient.getKeys().getKeysByPattern(pattern);
        for (String key : keys) {
            RBucket<Object> bucket = this.getRedisBucket(key);
            this.expire(bucket, (int)expire);
            set.add(bucket.get());
        }
        return set;
    }

    @Override
    public Boolean expire(String key, int seconds) {
        RBucket<Object> bucket = this.getRedisBucket(key);
        this.expire(bucket, seconds);
        return true;
    }

    @Override
    public void hset(String key, Serializable field, Serializable value) {
        this.redissonClient.getMap(key).put((Object)field, (Object)value);
    }

    @Override
    public Object hget(String key, Serializable field) {
        return this.redissonClient.getMap(key).get((Object)field);
    }

    @Override
    public void hdel(String key, Serializable field) {
        this.redissonClient.getMap(key).remove((Object)field);
    }

    public void sadd(String key, Serializable value) {
        this.redissonClient.getSet(key).add((Object)value);
    }

    public Set<Object> sall(String key) {
        return this.redissonClient.getSet(key).readAll();
    }

    public boolean sdel(String key, Serializable value) {
        return this.redissonClient.getSet(key).remove((Object)value);
    }

    @Override
    public boolean lock(String key, String requestId, long seconds) {
        return this.redissonClient.getBucket(key).trySet((Object)requestId, seconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean unlock(String key, String requestId) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        return (Boolean)this.redissonClient.getScript().eval(RScript.Mode.READ_WRITE, script, RScript.ReturnType.BOOLEAN, InstanceUtil.newArrayList(key), new Object[]{requestId});
    }

    @Override
    public boolean setnx(String key, Serializable value) {
        return this.redissonClient.getBucket(key).trySet((Object)value);
    }

    @Override
    public Long incr(String key) {
        return this.redissonClient.getAtomicLong(key).incrementAndGet();
    }

    @Override
    public Long incr(String key, int seconds) {
        Long incr = this.redissonClient.getAtomicLong(key).incrementAndGet();
        this.expire(key, seconds);
        return incr;
    }

    @Override
    public void setrange(String key, long offset, String value) {
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        return null;
    }
}

