/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.context;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import top.ibase4j.core.support.context.DubboContext;
import top.ibase4j.core.support.context.MotanContext;
import top.ibase4j.core.support.rpc.EnableDubboReference;
import top.ibase4j.core.support.rpc.EnableMotan;
import top.ibase4j.core.util.InstanceUtil;

@Component
public class ApplicationContextHolder
implements ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger();
    static ApplicationContext applicationContext;
    private static final Map<String, Object> SERVICE_FACTORY;
    private static final EnableDubboReference ENABLE_DUBBO;
    private static final EnableMotan ENABLE_MOTAN;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHolder.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> t) {
        return (T)applicationContext.getBean(t);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> t) {
        return applicationContext.getBeansOfType(t);
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(Class<T> cls) {
        String clsName = cls.getName();
        Object v = SERVICE_FACTORY.get(clsName);
        if (v == null) {
            String string = clsName;
            synchronized (string) {
                v = SERVICE_FACTORY.get(clsName);
                if (v == null) {
                    logger.info("*****Autowire {}*****", cls);
                    v = ENABLE_DUBBO.matches(null, null) ? DubboContext.getService(cls) : (ENABLE_MOTAN.matches(null, null) ? MotanContext.getService(cls) : ApplicationContextHolder.getBean(cls));
                    logger.info("*****{} Autowired*****", cls);
                    SERVICE_FACTORY.put(clsName, v);
                }
            }
        }
        return (T)v;
    }

    static {
        SERVICE_FACTORY = InstanceUtil.newHashMap();
        ENABLE_DUBBO = new EnableDubboReference();
        ENABLE_MOTAN = new EnableMotan();
    }
}

