/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.context;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.WebUtil;

@Aspect
@Component
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class RequestBodyAspect {
    private final Logger logger = LogManager.getLogger();
    private static Map<Class<?>, Method[]> methodMap = InstanceUtil.newHashMap();

    @Pointcut(value="execution(* *..*.web..*Controller.*(..))")
    public void requestBody() {
    }

    @Before(value="requestBody()")
    public void before(JoinPoint pjp) {
        block4: {
            try {
                Method[] methods;
                String methodName = pjp.getSignature().getName();
                Class<?> cls = pjp.getTarget().getClass();
                for (Method method : methods = this.getMethods(cls)) {
                    if (!method.getName().equals(methodName)) continue;
                    Parameter[] ps = method.getParameters();
                    for (int i = 0; i < ps.length; ++i) {
                        Parameter parameter = ps[i];
                        Object value = pjp.getArgs()[i];
                        RequestBody rb = parameter.getAnnotation(RequestBody.class);
                        if (rb == null) continue;
                        this.logger.info("Save RequestBody=>" + cls.getName() + "." + methodName);
                        String body = JSON.toJSONString((Object)value);
                        this.logger.info("request body===>{}", (Object)body);
                        WebUtil.REQUEST.get().setAttribute("iBase4J.requestBody", (Object)body);
                        break block4;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            }
        }
    }

    private Method[] getMethods(Class<?> cls) {
        if (methodMap.containsKey(cls)) {
            return methodMap.get(cls);
        }
        Method[] methods = cls.getDeclaredMethods();
        methodMap.put(cls, methods);
        return methods;
    }
}

