/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.file.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import top.ibase4j.core.support.file.excel.RowReader;

public class Excel2007Reader
extends DefaultHandler {
    private final Logger logger = LogManager.getLogger();
    private RowReader rowReader;
    private SharedStringsTable sst;
    private String currentCellValue;
    private boolean nextIsString;
    private int sheetIndex = -1;
    private List<String> rowlist = new ArrayList<String>();
    private int curRow = 0;
    private int curCol = 0;

    public void setRowReader(RowReader rowReader) {
        this.rowReader = rowReader;
    }

    public Excel2007Reader() {
    }

    public Excel2007Reader(RowReader rowReader) {
        this.rowReader = rowReader;
    }

    public void processOneSheet(String filename, int sheetId) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((String)filename);){
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            InputStream sheet2 = r.getSheet("rId" + sheetId);
            ++this.sheetIndex;
            InputSource sheetSource = new InputSource(sheet2);
            parser.parse(sheetSource);
            sheet2.close();
        }
    }

    public void process(InputStream stream) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((InputStream)stream);){
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            Iterator sheets = r.getSheetsData();
            while (sheets.hasNext()) {
                this.curRow = 0;
                ++this.sheetIndex;
                InputStream sheet = (InputStream)sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                parser.parse(sheetSource);
                sheet.close();
            }
        }
    }

    public void process(String filename) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((String)filename);){
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            Iterator sheets = r.getSheetsData();
            while (sheets.hasNext()) {
                this.curRow = 0;
                ++this.sheetIndex;
                InputStream sheet = (InputStream)sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                parser.parse(sheetSource);
                sheet.close();
            }
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.sst = sst;
            parser.setContentHandler(this);
            return parser;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentCellValue = this.currentCellValue + new String(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        this.startCell(name, attributes);
        this.currentCellValue = "";
    }

    private void startCell(String name, Attributes attributes) {
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            this.nextIsString = cellType != null && "s".equals(cellType);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if ("v".equals(name)) {
            this.endCellValue(name);
        } else {
            this.endRow(name);
        }
    }

    private void endCellValue(String name) {
        String value;
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.currentCellValue);
                this.currentCellValue = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
        }
        value = "".equals(value = this.currentCellValue.trim()) ? " " : value;
        this.rowlist.add(this.curCol, value);
        ++this.curCol;
    }

    private void endRow(String name) {
        if ("row".equals(name)) {
            if (this.rowReader != null && !this.rowlist.isEmpty()) {
                try {
                    this.rowReader.invoke(this.sheetIndex, this.curRow, this.rowlist);
                }
                catch (Exception e) {
                    this.logger.error("", (Object)"", (Object)e);
                }
            }
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
        }
    }
}

