/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.push;

import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.ExceptionUtil;

public abstract class BaseJPush {
    protected Logger logger = LogManager.getLogger();

    public abstract JPushClient getJPushClient();

    public boolean sendNotificationIOS(String title, String alert, Map<String, String> extras, String ... registrationId) {
        Audience audience = registrationId != null && registrationId.length > 0 ? Audience.registrationId((String[])registrationId) : Audience.all();
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(title, "", alert).build();
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(audience).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).addExtras(extras)).setSound(extras.get("sound")).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        try {
            PushResult result = this.getJPushClient().sendPush(payload);
            this.logger.info("==JPUSH==>{}", (Object)JSON.toJSONString((Object)result));
            return true;
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            return false;
        }
    }

    public boolean sendNotificationAndroid(String title, String alert, Map<String, String> extras, String ... registrationId) {
        Audience audience = registrationId != null && registrationId.length > 0 ? Audience.registrationId((String[])registrationId) : Audience.all();
        PushPayload payload = PushPayload.newBuilder().setAudience(audience).setPlatform(Platform.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setAlert((Object)alert).addExtras(extras)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        try {
            PushResult result = this.getJPushClient().sendPush(payload);
            this.logger.info("==JPUSH==>{}", (Object)JSON.toJSONString((Object)result));
            return true;
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            return false;
        }
    }

    public boolean sendNotificationAll(String title, String alert, Map<String, String> extras, String ... registrationId) {
        Audience audience = registrationId != null && registrationId.length > 0 ? Audience.registrationId((String[])registrationId) : Audience.all();
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(title, "", alert).build();
        PushPayload payload = PushPayload.newBuilder().setAudience(audience).setPlatform(Platform.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).addExtras(extras)).setSound(extras.get("sound")).build()).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setAlert((Object)alert).addExtras(extras)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        try {
            PushResult result = this.getJPushClient().sendPush(payload);
            this.logger.info("==JPUSH==>{}", (Object)JSON.toJSONString((Object)result));
            return true;
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            return false;
        }
    }
}

