/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.validate;

import java.lang.reflect.Field;
import top.ibase4j.core.exception.ValidateException;
import top.ibase4j.core.support.validate.RegexType;
import top.ibase4j.core.support.validate.Validate;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.IDCardUtil;

public class Validator {
    private Validator() {
    }

    public static void valid(Object object) throws Exception {
        Field[] fields;
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Validate validate = field.getAnnotation(Validate.class);
            if (validate != null) {
                Validator.validate(validate, field.get(object), field.getName());
            }
            field.setAccessible(false);
        }
    }

    public static void validate(Validate validate, Object value, String filedName) throws ValidateException {
        String description;
        String string = description = DataUtil.isEmpty(validate.desc()) ? filedName : validate.desc();
        if (validate.nullable() && DataUtil.isEmpty(value)) {
            return;
        }
        if (!validate.nullable() && DataUtil.isEmpty(value)) {
            throw new ValidateException(description + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (validate.min() != 0.0) {
            Double d = new Double(value.toString());
            if (d < validate.min()) {
                throw new ValidateException(description + "\u4e0d\u80fd\u5c0f\u4e8e" + validate.min());
            }
        }
        if (validate.max() != 0.0) {
            Double d = new Double(value.toString());
            if (d > validate.max()) {
                throw new ValidateException(description + "\u4e0d\u80fd\u5927\u4e8e" + validate.max());
            }
        }
        if (validate.minLength() != 0 && value.toString().length() < validate.minLength()) {
            throw new ValidateException(description + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + validate.minLength());
        }
        if (validate.maxLength() != 0 && value.toString().length() > validate.maxLength()) {
            throw new ValidateException(description + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + validate.maxLength());
        }
        Validator.validate(validate.type(), value, description);
        if (DataUtil.isNotEmpty(validate.regex()) && !value.toString().matches(validate.regex())) {
            throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public static void validate(RegexType type, Object value, String description) throws ValidateException {
        switch (type) {
            case NONE: {
                break;
            }
            case IDCARD: {
                if (IDCardUtil.isIdentity(value.toString())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            case DATE: {
                if (value.toString().matches(RegexType.DATE.value())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            case SPECIALCHAR: {
                if (!DataUtil.hasSpecialChar(value.toString())) break;
                throw new ValidateException(description + "\u4e0d\u80fd\u542b\u6709\u7279\u6b8a\u5b57\u7b26");
            }
            case PASSWORD: {
                if (DataUtil.isPassword(value.toString())) break;
                throw new ValidateException(description + "\u5fc5\u987b\u662f\u5927\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\uff0c\u957f\u5ea6\u57288-16\u4e4b\u95f4");
            }
            case CHINESE: {
                if (DataUtil.isChinese(value.toString())) break;
                throw new ValidateException(description + "\u53ea\u80fd\u8f93\u5165\u4e2d\u6587\u5b57\u7b26");
            }
            case NONECHINESE: {
                if (!DataUtil.isChinese2(value.toString())) break;
                throw new ValidateException(description + "\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\u5b57\u7b26");
            }
            case EMAIL: {
                if (DataUtil.isEmail(value.toString())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            case IP: {
                if (DataUtil.isIp(value.toString())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            case NUMBER: {
                if (DataUtil.isNumber(value.toString())) break;
                throw new ValidateException(description + "\u4e0d\u662f\u6570\u5b57");
            }
            case PHONE: {
                if (DataUtil.isPhone(value.toString())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            case TELEPHONE: {
                if (DataUtil.isTelephone(value.toString())) break;
                throw new ValidateException(description + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }
}

