/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.support.file.excel.WriteDone;

public class ExcelWriterPoiUtil {
    private static final Logger logger = LogManager.getLogger();

    public static void setResponseFileName(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        String displayName;
        String userAgent = request.getHeader("User-Agent");
        boolean isIE = false;
        if (userAgent != null && (userAgent.toLowerCase().contains("msie") || userAgent.toLowerCase().contains("rv"))) {
            isIE = true;
        }
        if (isIE) {
            displayName = URLEncoder.encode(fileName, "UTF-8");
            displayName = displayName.replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename=" + displayName);
        } else {
            displayName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + displayName + "\"");
        }
        String extStr = displayName.substring(displayName.indexOf(".") + 1);
        if ("xls".equalsIgnoreCase(extStr)) {
            response.setContentType("application/vnd.ms-excel");
        } else {
            response.setContentType("application/octet-stream");
        }
    }

    public static void createExcelTemplate(String filePath, String[] handers, List<String[]> downData, String[] downRows) throws BusinessException {
        OutputStream out = null;
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            out = ExcelWriterPoiUtil.writeTemplate(filePath, handers, downData, downRows, wb);
        }
        catch (IOException e) {
            throw new BusinessException(e);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static void createExcelTemplate(URL tplPath, String filePath, String[] handers, List<String[]> downData, String[] downRows) throws BusinessException {
        OutputStream out = null;
        try (HSSFWorkbook wb = new HSSFWorkbook(tplPath.openStream());){
            out = ExcelWriterPoiUtil.writeTemplate(filePath, handers, downData, downRows, wb);
        }
        catch (IOException e) {
            throw new BusinessException(e);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private static OutputStream writeTemplate(String filePath, String[] handers, List<String[]> downData, String[] downRows, HSSFWorkbook wb) throws IOException, FileNotFoundException {
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont fontStyle = wb.createFont();
        fontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fontStyle.setFontHeightInPoints((short)12);
        fontStyle.setBold(true);
        style.setFont(fontStyle);
        HSSFSheet sheet1 = wb.createSheet("Sheet1");
        HSSFSheet sheet2 = wb.createSheet("Sheet2");
        HSSFRow rowFirst = sheet1.createRow(0);
        for (int i = 0; i < handers.length; ++i) {
            HSSFCell cell = rowFirst.createCell(i);
            sheet1.setColumnWidth(i, 4000);
            cell.setCellStyle(style);
            cell.setCellValue(handers[i]);
        }
        String[] arr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        int index = 0;
        HSSFRow row = null;
        for (int r = 0; r < downRows.length; ++r) {
            String[] dlData = downData.get(r);
            int rownum = Integer.parseInt(downRows[r]);
            if (dlData.length < 5) {
                sheet1.addValidationData(ExcelWriterPoiUtil.setDataValidation((Sheet)sheet1, dlData, 1, 5, rownum, rownum));
                continue;
            }
            String strFormula = "Sheet2!$" + arr[index] + "$1:$" + arr[index] + "$5000";
            sheet2.setColumnWidth(r, 4000);
            sheet1.addValidationData((DataValidation)ExcelWriterPoiUtil.setDataValidation(strFormula, 1, 50000, rownum, rownum));
            for (int j = 0; j < dlData.length; ++j) {
                if (index == 0) {
                    row = sheet2.createRow(j);
                    sheet2.setColumnWidth(j, 4000);
                    row.createCell(0).setCellValue(dlData[j]);
                    continue;
                }
                int rowCount = sheet2.getLastRowNum();
                if (j <= rowCount) {
                    sheet2.getRow(j).createCell(index).setCellValue(dlData[j]);
                    continue;
                }
                sheet2.setColumnWidth(j, 4000);
                sheet2.createRow(j).createCell(index).setCellValue(dlData[j]);
            }
            ++index;
        }
        File f = new File(filePath);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new BusinessException("");
        }
        if (!f.exists() && !f.createNewFile()) {
            throw new BusinessException("");
        }
        FileOutputStream out = new FileOutputStream(f);
        out.flush();
        wb.write((OutputStream)out);
        return out;
    }

    private static HSSFDataValidation setDataValidation(String strFormula, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)strFormula);
        HSSFDataValidation dataValidation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        dataValidation.createErrorBox("Error", "Error");
        dataValidation.createPromptBox("", null);
        return dataValidation;
    }

    private static DataValidation setDataValidation(Sheet sheet, String[] textList, int firstRow, int endRow, int firstCol, int endCol) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createExplicitListConstraint(textList);
        constraint.setExplicitListValues(textList);
        CellRangeAddressList regions = new CellRangeAddressList((int)((short)firstRow), (int)((short)endRow), (int)((short)firstCol), (int)((short)endCol));
        return helper.createValidation(constraint, regions);
    }

    public static void exportToExcel(OutputStream os, List<List<String>> data) throws IOException {
        ExcelWriterPoiUtil.exportToExcel(os, data, null);
    }

    public static void exportToExcel(OutputStream os, List<List<String>> data, String title) throws IOException {
        ExcelWriterPoiUtil.exportToExcel(os, data, title, null);
    }

    public static void exportToExcel(OutputStream os, List<List<String>> data, String title, WriteDone writeDone) throws IOException {
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            HSSFSheet sheet = wb.createSheet("Data");
            Map<String, CellStyle> styles = ExcelWriterPoiUtil.createStyles(wb);
            if (StringUtils.isNotBlank((CharSequence)title)) {
                HSSFRow titleRow = sheet.createRow(0);
                titleRow.setHeightInPoints(30.0f);
                Cell titleCell = titleRow.createCell(0);
                titleCell.setCellStyle(styles.get("title"));
                titleCell.setCellValue(title);
                sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), titleRow.getRowNum(), data.get(0).size() - 1));
            }
            int col = 0;
            for (int r = 0; r < data.size(); ++r) {
                HSSFRow row = sheet.createRow(r + 1);
                List<String> cols = data.get(r);
                for (int c = 0; c < cols.size(); ++c) {
                    HSSFCell cell = row.createCell(c);
                    if (r == 0) {
                        cell.setCellStyle(styles.get("header"));
                    } else {
                        cell.setCellStyle(styles.get("data"));
                    }
                    cell.setCellValue((RichTextString)new HSSFRichTextString(cols.get(c)));
                }
                col = Math.max(col, cols.size());
            }
            for (int i = 0; i < col; ++i) {
                sheet.autoSizeColumn((int)((short)i));
            }
            if (writeDone != null) {
                writeDone.invoke(sheet);
            }
            if (wb != null) {
                wb.write(os);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            os.flush();
            os.close();
        }
    }

    private static Map<String, CellStyle> createStyles(HSSFWorkbook wb) {
        HashMap styleMap = Maps.newHashMap();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont titleFont = wb.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setBold(true);
        style.setFont((Font)titleFont);
        styleMap.put("title", style);
        style = wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        HSSFFont dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont((Font)dataFont);
        styleMap.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styleMap.get("data"));
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.BLACK.getIndex());
        style.setFont((Font)headerFont);
        styleMap.put("header", style);
        return styleMap;
    }
}

