/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.math.BigDecimal;

public strictfp final class MathUtil {
    private static int DEF_SCALE = 10;

    private MathUtil() {
    }

    public static final BigDecimal bigDecimal(Object object) {
        BigDecimal result;
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        try {
            result = new BigDecimal(object.toString().replaceAll(",", ""));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Please give me a numeral.Not " + object);
        }
        return result;
    }

    public static final BigDecimal add(Number num1, Number num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).add(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4);
    }

    public static final BigDecimal subtract(Number num1, Number num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).subtract(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4);
    }

    public static final BigDecimal multiply(Number num1, Number num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).multiply(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4);
    }

    public static final BigDecimal divide(Number num1, Number num2) {
        return MathUtil.divide(num1, num2, DEF_SCALE);
    }

    public static final BigDecimal divide(Number num1, Number num2, Integer scale) {
        if (scale == null) {
            scale = DEF_SCALE;
        }
        Number number = num2 = num2 == null || Math.abs(new Double(num2.toString())) == 0.0 ? (Number)1 : (Number)num2;
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtil.bigDecimal(num1).divide(MathUtil.bigDecimal(num2), (int)scale, 4);
        return result;
    }

    public static final BigDecimal round(Number num, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtil.bigDecimal(num).divide(MathUtil.bigDecimal("1"), scale, 4);
        return result;
    }

    public static final BigDecimal getRandom(double start, double end) {
        return new BigDecimal(start + Math.random() * (end - start));
    }

    public static final void main(String[] args) {
        System.out.println(MathUtil.add(1.000001, 2.1));
    }
}

