/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.MathUtil;

public final class ThreadUtil {
    static Logger logger = LogManager.getLogger();
    static final Map<String, ExecutorService> EXECUTORS = InstanceUtil.newConcurrentHashMap();
    static final Map<String, List<Future<?>>> FUTURES = InstanceUtil.newConcurrentHashMap();
    static final Map<String, Lock> LOCKS = InstanceUtil.newConcurrentHashMap();

    public static void sleep(int start, int end) {
        try {
            Thread.sleep(MathUtil.getRandom(start, end).longValue());
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtil.getStackTraceAsString(e));
        }
    }

    public static void sleep(long seconds) {
        block2: {
            try {
                Thread.sleep(seconds * 1000L);
            }
            catch (InterruptedException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug(e.getMessage());
            }
        }
    }

    public static ExecutorService threadPool(String threadName, int core, int seconds) {
        logger.info("Freed threadPoolExecutor " + threadName);
        return new ThreadPoolExecutor(core, core, (long)seconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(threadName + "-%d").build());
    }

    public static void execute(String threadName, Runnable runnable) {
        ThreadUtil.execute(threadName, 5, 60, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String threadName, int core, int seconds, Runnable runnable) {
        if (!LOCKS.containsKey(threadName)) {
            LOCKS.put(threadName, new ReentrantLock(true));
        }
        LOCKS.get(threadName).lock();
        try {
            boolean first;
            boolean bl = first = EXECUTORS.get(threadName) == null;
            if (first) {
                EXECUTORS.putIfAbsent(threadName, ThreadUtil.threadPool(threadName, core, seconds));
                if (FUTURES.get(threadName) == null) {
                    FUTURES.putIfAbsent(threadName, InstanceUtil.newArrayList());
                } else {
                    FUTURES.get(threadName).clear();
                }
            }
            ExecutorService executorService = EXECUTORS.get(threadName);
            Future<?> future = executorService.submit(runnable);
            FUTURES.get(threadName).add(future);
            if (first) {
                ThreadUtil.shutdown(threadName);
            }
        }
        finally {
            LOCKS.get(threadName).unlock();
        }
    }

    private static void shutdown(final String threadName) {
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LOCKS.get(threadName).tryLock()) {
                    try {
                        boolean done = true;
                        for (Future<?> future : FUTURES.get(threadName)) {
                            if (future.isDone()) continue;
                            done = false;
                        }
                        if (done) {
                            EXECUTORS.get(threadName).shutdown();
                            EXECUTORS.remove(threadName);
                            FUTURES.get(threadName).clear();
                            timer.cancel();
                            logger.info("Freed threadPoolExecutor " + threadName);
                        }
                    }
                    finally {
                        LOCKS.get(threadName).unlock();
                    }
                }
            }
        }, 60000L, 180000L);
    }
}

