/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import top.ibase4j.core.util.DataUtil;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static final Map parseXml2Map(String pStrXml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element elNode = document.getRootElement();
        Iterator it = elNode.elementIterator();
        while (it.hasNext()) {
            Element leaf = (Element)it.next();
            map.put(leaf.getName().toLowerCase(), leaf.getData());
        }
        return map;
    }

    public static Map dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Map> mapList = new ArrayList<Object>();
                if (iter.elements().size() > 0) {
                    Map m = XmlUtil.dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!"java.util.ArrayList".equals(obj.getClass().getName())) {
                            mapList = new ArrayList();
                            mapList.add((Map)obj);
                            mapList.add(m);
                        } else if ("java.util.ArrayList".equals(obj.getClass().getName())) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!"java.util.ArrayList".equals(obj.getClass().getName())) {
                        mapList = new ArrayList();
                        mapList.add((Map)obj);
                        mapList.add((Map)((Object)iter.getText()));
                    } else if ("java.util.ArrayList".equals(obj.getClass().getName())) {
                        mapList = (List)obj;
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static final Map parseXml2Map(String pStrXml, String pXPath) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element elNode = document.getRootElement();
        Iterator it = elNode.elementIterator();
        while (it.hasNext()) {
            Element leaf = (Element)it.next();
            map.put(leaf.getName().toLowerCase(), leaf.getData());
        }
        return map;
    }

    public static final String parseDto2Xml(Map<String, String> map, String pRootNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element leaf = root.addElement(entry.getKey());
            leaf.setText(entry.getValue());
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseDto2XmlHasHead(Map<String, String> map, String pRootNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element leaf = root.addElement(entry.getKey());
            leaf.setText(entry.getValue());
        }
        String outXml = document.asXML();
        return outXml;
    }

    public static final String parseMap2Xml(Map<String, String> map, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        root.addElement(pFirstNodeName);
        Element firstEl = (Element)document.selectSingleNode("/" + pRootNodeName + "/" + pFirstNodeName);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            firstEl.addAttribute(entry.getKey(), entry.getValue());
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseList2Xml(List pList, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        Element elRoot = document.addElement(pRootNodeName);
        for (int i = 0; i < pList.size(); ++i) {
            Map map = (Map)pList.get(i);
            Element elRow = elRoot.addElement(pFirstNodeName);
            for (Map.Entry entry : map.entrySet()) {
                elRow.addAttribute((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseList2XmlBasedNode(List pList, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        Element output = document.addElement(pRootNodeName);
        for (int i = 0; i < pList.size(); ++i) {
            Map map = (Map)pList.get(i);
            Element elRow = output.addElement(pFirstNodeName);
            for (Map.Entry entry : map.entrySet()) {
                Element leaf = elRow.addElement((String)entry.getKey());
                leaf.setText(String.valueOf(entry.getValue()));
            }
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final List parseXml2List(String pStrXml) {
        ArrayList lst = new ArrayList();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element elRoot = document.getRootElement();
        Iterator elIt = elRoot.elementIterator();
        while (elIt.hasNext()) {
            Element el = (Element)elIt.next();
            Iterator attrIt = el.attributeIterator();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (attrIt.hasNext()) {
                Attribute attribute = (Attribute)attrIt.next();
                map.put(attribute.getName().toLowerCase(), attribute.getData());
            }
            lst.add(map);
        }
        return lst;
    }

    public static Map<String, Object> dom2Map(Document doc) {
        HashMap<String, Object> maproot = new HashMap<String, Object>();
        if (doc == null) {
            return maproot;
        }
        Element root = doc.getRootElement();
        List list1 = root.elements();
        for (Object obj : list1) {
            Element element = (Element)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            XmlUtil.element2Map(element, map);
            maproot.put(element.getName(), map);
        }
        return maproot;
    }

    public static void element2Map(Element e, Map<String, Object> map) {
        List list = e.elements();
        if (e.attributeCount() > 0) {
            for (Object attri : e.attributes()) {
                Attribute at = (Attribute)attri;
                map.put(at.getName(), at.getValue());
            }
        }
        if (list.size() < 1 && DataUtil.isEmpty(e.getText())) {
            return;
        }
        if (list.size() < 1 && !DataUtil.isEmpty(e.getText())) {
            map.put("text", e.getText());
        }
        for (Object aList : list) {
            Element iter = (Element)aList;
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            XmlUtil.element2Map(iter, cMap);
            map.put(iter.getName(), cMap);
        }
    }
}

