/*
 * Decompiled with CFR 0.152.
 */
package de.micromata.opengis.kml.v_2_2_0;

import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Coordinate", namespace="http://www.opengis.net/kml/2.2")
public class Coordinate
implements Cloneable {
    protected double longitude;
    protected double latitude;
    protected double altitude;

    @Deprecated
    private Coordinate() {
    }

    public Coordinate(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public Coordinate(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public Coordinate(String coordinates) {
        String[] coords = coordinates.replaceAll(",\\s+", ",").trim().split(",");
        if (coords.length < 1 && coords.length > 3) {
            throw new IllegalArgumentException();
        }
        this.longitude = Double.parseDouble(coords[0]);
        this.latitude = Double.parseDouble(coords[1]);
        if (coords.length == 3) {
            this.altitude = Double.parseDouble(coords[2]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.longitude);
        sb.append(",");
        sb.append(this.latitude);
        if (this.altitude != 0.0) {
            sb.append(",");
            sb.append(this.altitude);
        }
        return sb.toString();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Coordinate setLongitude(double longitude) {
        this.longitude = longitude;
        return this;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Coordinate setLatitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Coordinate setAltitude(double altitude) {
        this.altitude = altitude;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coordinate)) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (this.longitude != other.longitude) {
            return false;
        }
        if (this.latitude != other.latitude) {
            return false;
        }
        return this.altitude == other.altitude;
    }

    public Coordinate withLongitude(double longitude) {
        this.setLongitude(longitude);
        return this;
    }

    public Coordinate withLatitude(double latitude) {
        this.setLatitude(latitude);
        return this;
    }

    public Coordinate withAltitude(double altitude) {
        this.setAltitude(altitude);
        return this;
    }

    public Coordinate clone() {
        Coordinate copy;
        try {
            copy = (Coordinate)super.clone();
        }
        catch (CloneNotSupportedException _x) {
            throw new InternalError(_x.toString());
        }
        return copy;
    }
}

