/*
 * Decompiled with CFR 0.152.
 */
package de.micromata.opengis.kml.v_2_2_0;

import de.micromata.opengis.kml.v_2_2_0.AbstractObject;
import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.BooleanConverter;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.annotations.Obvious;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PolygonType", propOrder={"extrude", "tessellate", "altitudeMode", "outerBoundaryIs", "innerBoundaryIs", "polygonSimpleExtension", "polygonObjectExtension"})
@XmlRootElement(name="Polygon", namespace="http://www.opengis.net/kml/2.2")
public class Polygon
extends Geometry
implements Cloneable {
    @XmlElement(defaultValue="0")
    @XmlJavaTypeAdapter(value=BooleanConverter.class)
    protected Boolean extrude;
    @XmlElement(defaultValue="0")
    @XmlJavaTypeAdapter(value=BooleanConverter.class)
    protected Boolean tessellate;
    @XmlElement(defaultValue="clampToGround")
    protected AltitudeMode altitudeMode;
    protected Boundary outerBoundaryIs;
    protected List<Boundary> innerBoundaryIs;
    @XmlElement(name="PolygonSimpleExtensionGroup")
    @XmlSchemaType(name="anySimpleType")
    protected List<Object> polygonSimpleExtension;
    @XmlElement(name="PolygonObjectExtensionGroup")
    protected List<AbstractObject> polygonObjectExtension;

    public Boolean isExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean value) {
        this.extrude = value;
    }

    public Boolean isTessellate() {
        return this.tessellate;
    }

    public void setTessellate(Boolean value) {
        this.tessellate = value;
    }

    public AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeMode value) {
        this.altitudeMode = value;
    }

    public Boundary getOuterBoundaryIs() {
        return this.outerBoundaryIs;
    }

    public void setOuterBoundaryIs(Boundary value) {
        this.outerBoundaryIs = value;
    }

    public List<Boundary> getInnerBoundaryIs() {
        if (this.innerBoundaryIs == null) {
            this.innerBoundaryIs = new ArrayList<Boundary>();
        }
        return this.innerBoundaryIs;
    }

    public List<Object> getPolygonSimpleExtension() {
        if (this.polygonSimpleExtension == null) {
            this.polygonSimpleExtension = new ArrayList<Object>();
        }
        return this.polygonSimpleExtension;
    }

    public List<AbstractObject> getPolygonObjectExtension() {
        if (this.polygonObjectExtension == null) {
            this.polygonObjectExtension = new ArrayList<AbstractObject>();
        }
        return this.polygonObjectExtension;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extrude == null ? 0 : this.extrude.hashCode());
        result = 31 * result + (this.tessellate == null ? 0 : this.tessellate.hashCode());
        result = 31 * result + (this.altitudeMode == null ? 0 : this.altitudeMode.hashCode());
        result = 31 * result + (this.outerBoundaryIs == null ? 0 : this.outerBoundaryIs.hashCode());
        result = 31 * result + (this.innerBoundaryIs == null ? 0 : this.innerBoundaryIs.hashCode());
        result = 31 * result + (this.polygonSimpleExtension == null ? 0 : this.polygonSimpleExtension.hashCode());
        result = 31 * result + (this.polygonObjectExtension == null ? 0 : this.polygonObjectExtension.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Polygon)) {
            return false;
        }
        Polygon other = (Polygon)obj;
        if (this.extrude == null ? other.extrude != null : !this.extrude.equals(other.extrude)) {
            return false;
        }
        if (this.tessellate == null ? other.tessellate != null : !this.tessellate.equals(other.tessellate)) {
            return false;
        }
        if (this.altitudeMode == null ? other.altitudeMode != null : !this.altitudeMode.equals((Object)other.altitudeMode)) {
            return false;
        }
        if (this.outerBoundaryIs == null ? other.outerBoundaryIs != null : !this.outerBoundaryIs.equals(other.outerBoundaryIs)) {
            return false;
        }
        if (this.innerBoundaryIs == null ? other.innerBoundaryIs != null : !this.innerBoundaryIs.equals(other.innerBoundaryIs)) {
            return false;
        }
        if (this.polygonSimpleExtension == null ? other.polygonSimpleExtension != null : !this.polygonSimpleExtension.equals(other.polygonSimpleExtension)) {
            return false;
        }
        return !(this.polygonObjectExtension == null ? other.polygonObjectExtension != null : !this.polygonObjectExtension.equals(other.polygonObjectExtension));
    }

    public Boundary createAndSetOuterBoundaryIs() {
        Boundary newValue = new Boundary();
        this.setOuterBoundaryIs(newValue);
        return newValue;
    }

    public Boundary createAndAddInnerBoundaryIs() {
        Boundary newValue = new Boundary();
        this.getInnerBoundaryIs().add(newValue);
        return newValue;
    }

    public void setInnerBoundaryIs(List<Boundary> innerBoundaryIs) {
        this.innerBoundaryIs = innerBoundaryIs;
    }

    public Polygon addToInnerBoundaryIs(Boundary innerBoundaryIs) {
        this.getInnerBoundaryIs().add(innerBoundaryIs);
        return this;
    }

    public void setPolygonSimpleExtension(List<Object> polygonSimpleExtension) {
        this.polygonSimpleExtension = polygonSimpleExtension;
    }

    public Polygon addToPolygonSimpleExtension(Object polygonSimpleExtension) {
        this.getPolygonSimpleExtension().add(polygonSimpleExtension);
        return this;
    }

    public void setPolygonObjectExtension(List<AbstractObject> polygonObjectExtension) {
        this.polygonObjectExtension = polygonObjectExtension;
    }

    public Polygon addToPolygonObjectExtension(AbstractObject polygonObjectExtension) {
        this.getPolygonObjectExtension().add(polygonObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public void setObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.setObjectSimpleExtension(objectSimpleExtension);
    }

    @Override
    @Obvious
    public Polygon addToObjectSimpleExtension(Object objectSimpleExtension) {
        super.getObjectSimpleExtension().add(objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.setGeometrySimpleExtension(geometrySimpleExtension);
    }

    @Override
    @Obvious
    public Polygon addToGeometrySimpleExtension(Object geometrySimpleExtension) {
        super.getGeometrySimpleExtension().add(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.setGeometryObjectExtension(geometryObjectExtension);
    }

    @Override
    @Obvious
    public Polygon addToGeometryObjectExtension(AbstractObject geometryObjectExtension) {
        super.getGeometryObjectExtension().add(geometryObjectExtension);
        return this;
    }

    public Polygon withExtrude(Boolean extrude) {
        this.setExtrude(extrude);
        return this;
    }

    public Polygon withTessellate(Boolean tessellate) {
        this.setTessellate(tessellate);
        return this;
    }

    public Polygon withAltitudeMode(AltitudeMode altitudeMode) {
        this.setAltitudeMode(altitudeMode);
        return this;
    }

    public Polygon withOuterBoundaryIs(Boundary outerBoundaryIs) {
        this.setOuterBoundaryIs(outerBoundaryIs);
        return this;
    }

    public Polygon withInnerBoundaryIs(List<Boundary> innerBoundaryIs) {
        this.setInnerBoundaryIs(innerBoundaryIs);
        return this;
    }

    public Polygon withPolygonSimpleExtension(List<Object> polygonSimpleExtension) {
        this.setPolygonSimpleExtension(polygonSimpleExtension);
        return this;
    }

    public Polygon withPolygonObjectExtension(List<AbstractObject> polygonObjectExtension) {
        this.setPolygonObjectExtension(polygonObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public Polygon withObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.withObjectSimpleExtension((List)objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public Polygon withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    @Obvious
    public Polygon withTargetId(String targetId) {
        super.withTargetId(targetId);
        return this;
    }

    @Override
    @Obvious
    public Polygon withGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.withGeometrySimpleExtension(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public Polygon withGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.withGeometryObjectExtension(geometryObjectExtension);
        return this;
    }

    @Override
    public Polygon clone() {
        Polygon copy = (Polygon)super.clone();
        copy.outerBoundaryIs = this.outerBoundaryIs == null ? null : this.outerBoundaryIs.clone();
        copy.innerBoundaryIs = new ArrayList<Boundary>(this.getInnerBoundaryIs().size());
        for (Boundary boundary : this.innerBoundaryIs) {
            copy.innerBoundaryIs.add(boundary.clone());
        }
        copy.polygonSimpleExtension = new ArrayList<Object>(this.getPolygonSimpleExtension().size());
        for (Object object : this.polygonSimpleExtension) {
            copy.polygonSimpleExtension.add(object);
        }
        copy.polygonObjectExtension = new ArrayList<AbstractObject>(this.getPolygonObjectExtension().size());
        for (AbstractObject abstractObject : this.polygonObjectExtension) {
            copy.polygonObjectExtension.add(abstractObject.clone());
        }
        return copy;
    }
}

