/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.jenkins.v1.JenkinsApi;
import org.jclouds.jenkins.v1.JenkinsAsyncApi;
import org.jclouds.jenkins.v1.features.ComputerApi;
import org.jclouds.jenkins.v1.features.ComputerAsyncApi;
import org.jclouds.jenkins.v1.features.JobApi;
import org.jclouds.jenkins.v1.features.JobAsyncApi;
import org.jclouds.jenkins.v1.handlers.JenkinsErrorHandler;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class JenkinsRestClientModule
extends RestClientModule<JenkinsApi, JenkinsAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ComputerApi.class, ComputerAsyncApi.class).put(JobApi.class, JobAsyncApi.class).build();

    public JenkinsRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(JenkinsErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(JenkinsErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(JenkinsErrorHandler.class);
    }
}

