/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Computer
implements Comparable<Computer> {
    protected final String displayName;
    protected final boolean idle;
    protected final boolean offline;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Computer.builder().fromComputerMetadata(this);
    }

    public Computer(String displayName, boolean idle, boolean offline) {
        this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        this.idle = idle;
        this.offline = offline;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Computer) {
            Computer other = (Computer)Computer.class.cast(object);
            return Objects.equal((Object)this.getDisplayName(), (Object)other.getDisplayName()) && Objects.equal((Object)this.isIdle(), (Object)other.isIdle()) && Objects.equal((Object)this.isOffline(), (Object)other.isOffline());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getDisplayName(), this.isIdle(), this.isOffline()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("displayName", (Object)this.getDisplayName()).add("idle", this.isIdle()).add("offline", this.isOffline());
    }

    @Override
    public int compareTo(Computer that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getDisplayName().compareTo(that.getDisplayName());
    }

    public static class Builder {
        protected String displayName;
        protected boolean idle;
        protected boolean offline;

        public Builder displayName(String displayName) {
            this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
            return this;
        }

        public Builder idle(boolean idle) {
            this.idle = idle;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Computer build() {
            return new Computer(this.displayName, this.idle, this.offline);
        }

        public Builder fromComputerMetadata(Computer from) {
            return this.displayName(from.getDisplayName()).idle(from.isIdle()).offline(from.isOffline());
        }
    }
}

