/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Set;
import org.jclouds.jenkins.v1.domain.Computer;

public class ComputerView
implements Comparable<ComputerView> {
    protected final String displayName;
    protected final int busyExecutors;
    protected final int totalExecutors;
    @SerializedName(value="computer")
    protected final Set<Computer> computers;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ComputerView.builder().fromComputerMetadata(this);
    }

    public ComputerView(String displayName, int busyExecutors, int totalExecutors, Set<Computer> computers) {
        this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        this.busyExecutors = busyExecutors;
        this.totalExecutors = totalExecutors;
        this.computers = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(computers, (Object)"computers")));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getBusyExecutors() {
        return this.busyExecutors;
    }

    public int getTotalExecutors() {
        return this.totalExecutors;
    }

    public Set<Computer> getComputers() {
        return this.computers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ComputerView) {
            ComputerView other = (ComputerView)ComputerView.class.cast(object);
            return Objects.equal((Object)this.getDisplayName(), (Object)other.getDisplayName()) && Objects.equal((Object)this.getBusyExecutors(), (Object)other.getBusyExecutors()) && Objects.equal((Object)this.getTotalExecutors(), (Object)other.getTotalExecutors()) && Objects.equal(this.getComputers(), other.getComputers());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getDisplayName(), this.getBusyExecutors(), this.getTotalExecutors(), this.getComputers()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("displayName", (Object)this.getDisplayName()).add("busyExecutors", this.getBusyExecutors()).add("totalExecutors", this.getTotalExecutors()).add("computers", this.getComputers());
    }

    @Override
    public int compareTo(ComputerView that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getDisplayName().compareTo(that.getDisplayName());
    }

    public static class Builder {
        protected String displayName;
        protected int busyExecutors;
        protected int totalExecutors;
        protected Set<Computer> computers = ImmutableSet.of();

        public Builder displayName(String displayName) {
            this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
            return this;
        }

        public Builder busyExecutors(int busyExecutors) {
            this.busyExecutors = busyExecutors;
            return this;
        }

        public Builder totalExecutors(int totalExecutors) {
            this.totalExecutors = totalExecutors;
            return this;
        }

        public Builder computers(Computer ... computers) {
            return this.computers((Set<Computer>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)computers, (Object)"computers"))));
        }

        public Builder computers(Set<Computer> computers) {
            this.computers = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(computers, (Object)"computers")));
            return this;
        }

        public ComputerView build() {
            return new ComputerView(this.displayName, this.busyExecutors, this.totalExecutors, this.computers);
        }

        public Builder fromComputerMetadata(ComputerView from) {
            return this.displayName(from.getDisplayName()).busyExecutors(from.getBusyExecutors()).totalExecutors(from.getTotalExecutors()).computers(from.getComputers());
        }
    }
}

