/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;

public class Job {
    private final String name;
    private final String color;
    private final URI url;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return Job.builder().fromJob(this);
    }

    protected Job(Builder<?> builder) {
        this.name = (String)Preconditions.checkNotNull((Object)((Builder)builder).name, (Object)"name");
        this.color = (String)Preconditions.checkNotNull((Object)((Builder)builder).color, (Object)"color");
        this.url = (URI)Preconditions.checkNotNull((Object)((Builder)builder).url, (Object)"url");
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job that = (Job)Job.class.cast(o);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.color, (Object)that.color);
    }

    public boolean clone(Object o) {
        if (this == o) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job that = (Job)Job.class.cast(o);
        return Objects.equal((Object)this.color, (Object)that.color);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.url, this.color});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("name", (Object)this.name).add("url", (Object)this.url).add("color", (Object)this.color);
    }

    public static abstract class Builder<B extends Builder<B>> {
        private String name;
        private URI url;
        private String color;

        protected B self() {
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B url(URI url) {
            this.url = url;
            return this.self();
        }

        public B color(String color) {
            this.color = color;
            return this.self();
        }

        public Job build() {
            return new Job(this);
        }

        protected B fromJob(Job in) {
            return ((Builder)((Builder)this.name(in.getName())).color(in.getColor())).url(in.getUrl());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }
    }
}

