/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Set;
import org.jclouds.jenkins.v1.domain.Job;

public class Node
implements Comparable<Node> {
    @SerializedName(value="nodeName")
    protected final String name;
    @SerializedName(value="nodeDescription")
    protected final String description;
    protected final Set<Job> jobs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Node.builder().fromNodeMetadata(this);
    }

    public Node(String name, String description, Set<Job> jobs) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
        this.jobs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(jobs, (Object)"jobs")));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Job> getJobs() {
        return this.jobs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Node) {
            Node other = (Node)Node.class.cast(object);
            return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getDescription(), (Object)other.getDescription()) && Objects.equal(this.getJobs(), other.getJobs());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getDescription(), this.getJobs()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).add("jobs", this.getJobs());
    }

    @Override
    public int compareTo(Node that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public static class Builder {
        protected String name;
        protected String description;
        protected Set<Job> jobs = ImmutableSet.of();

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder jobs(Job ... jobs) {
            return this.jobs((Set<Job>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)jobs, (Object)"jobs"))));
        }

        public Builder jobs(Set<Job> jobs) {
            this.jobs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(jobs, (Object)"jobs")));
            return this;
        }

        public Node build() {
            return new Node(this.name, this.description, this.jobs);
        }

        public Builder fromNodeMetadata(Node from) {
            return this.name(from.getName()).description(from.getDescription()).jobs(from.getJobs());
        }
    }
}

