/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.jenkins.v1.binders.BindMapToOptionalParams;
import org.jclouds.jenkins.v1.domain.JobDetails;
import org.jclouds.jenkins.v1.domain.LastBuild;
import org.jclouds.jenkins.v1.filters.BasicAuthenticationUnlessAnonymous;
import org.jclouds.jenkins.v1.functions.ReturnVoidOn302Or404;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={BasicAuthenticationUnlessAnonymous.class})
public interface JobAsyncApi {
    @POST
    @Path(value="/createItem")
    @Produces(value={"text/xml"})
    public ListenableFuture<Void> createFromXML(@QueryParam(value="name") String var1, @BinderParam(value=BindToStringPayload.class) String var2);

    @GET
    @Path(value="/job/{displayName}/api/json")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<JobDetails> get(@PathParam(value="displayName") String var1);

    @POST
    @Path(value="/job/{displayName}/doDelete")
    @ExceptionParser(value=ReturnVoidOn302Or404.class)
    public ListenableFuture<Void> delete(@PathParam(value="displayName") String var1);

    @POST
    @Path(value="/job/{displayName}/build")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> build(@PathParam(value="displayName") String var1);

    @POST
    @Path(value="/job/{displayName}/buildWithParameters")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> buildWithParameters(@PathParam(value="displayName") String var1, @BinderParam(value=BindMapToOptionalParams.class) Map<String, String> var2);

    @GET
    @Path(value="/job/{displayName}/config.xml")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<String> fetchConfigXML(@PathParam(value="displayName") String var1);

    @GET
    @Path(value="/job/{displayName}/lastBuild/api/json")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<LastBuild> lastBuild(@PathParam(value="displayName") String var1);
}

