/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.jenkins.v1.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.location.Provider;

@Singleton
public class BasicAuthenticationUnlessAnonymous
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;
    private final BasicAuthentication auth;

    @Inject
    public BasicAuthenticationUnlessAnonymous(@Provider Supplier<Credentials> creds, BasicAuthentication auth) {
        this.creds = (Supplier)Preconditions.checkNotNull(creds, (Object)"creds");
        this.auth = (BasicAuthentication)Preconditions.checkNotNull((Object)auth, (Object)"auth");
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        if ("ANONYMOUS".equals(Preconditions.checkNotNull((Object)((Credentials)this.creds.get()).identity, (Object)"user"))) {
            return request;
        }
        return this.auth.filter(request);
    }
}

