/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public abstract class GenericGeometryPropertyFunction
extends PFuncSimple {
    protected abstract NodeValue applyPredicate(GeometryWrapper var1);

    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        if (subject.isConcrete() && object.isLiteral()) {
            return this.bothBound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isVariable() && object.isVariable()) {
            return this.bothUnbound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isConcrete() && object.isVariable()) {
            return this.objectUnbound(binding, subject, predicate, object, execCxt);
        }
        return this.subjectUnbound(binding, subject, predicate, object, execCxt);
    }

    protected Node getGeometryLiteral(Node subject, Node predicate, Graph graph) throws ExprEvalException {
        try {
            if (graph.contains(subject, predicate, null)) {
                ExtendedIterator iter = graph.find(subject, predicate, null);
                Node geometryLiteral = GenericGeometryPropertyFunction.extractObject((ExtendedIterator<Triple>)iter);
                return geometryLiteral;
            }
            ExtendedIterator iter = graph.find(subject, Geo.HAS_SERIALIZATION_NODE, null);
            Node geomLiteral = GenericGeometryPropertyFunction.extractObject((ExtendedIterator<Triple>)iter);
            if (geomLiteral == null && (geomLiteral = GenericGeometryPropertyFunction.extractObject((ExtendedIterator<Triple>)(iter = graph.find(subject, Geo.AS_WKT_NODE, null)))) == null) {
                iter = graph.find(subject, Geo.AS_GML_NODE, null);
                geomLiteral = GenericGeometryPropertyFunction.extractObject((ExtendedIterator<Triple>)iter);
            }
            if (geomLiteral != null) {
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geomLiteral);
                NodeValue predicateResult = this.applyPredicate(geometryWrapper);
                return predicateResult.asNode();
            }
            return null;
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static Node extractObject(ExtendedIterator<Triple> iter) {
        if (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            return triple.getObject();
        }
        return null;
    }

    private QueryIterator bothBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        Node geometryLiteral = this.getGeometryLiteral(subject, predicate, graph);
        if (geometryLiteral != null && object.matches(geometryLiteral)) {
            return QueryIterSingleton.create((Binding)binding, (ExecutionContext)execCxt);
        }
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    private QueryIterator subjectUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
        Graph graph = execCxt.getActiveGraph();
        ExtendedIterator subjectTriples = graph.find(null, RDF.type.asNode(), Geo.GEOMETRY_NODE);
        Var subjectVar = Var.alloc((String)subject.getName());
        while (subjectTriples.hasNext()) {
            Triple subjectTriple = (Triple)subjectTriples.next();
            Binding newBind = BindingFactory.binding((Binding)binding, (Var)subjectVar, (Node)subjectTriple.getSubject());
            QueryIterator queryIter = this.bothBound(newBind, subjectTriple.getSubject(), predicate, object, execCxt);
            queryIterConcat.add(queryIter);
        }
        return queryIterConcat;
    }

    private QueryIterator objectUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        Node geometryLiteral = this.getGeometryLiteral(subject, predicate, graph);
        if (geometryLiteral != null) {
            return QueryIterSingleton.create((Binding)binding, (Var)Var.alloc((String)object.getName()), (Node)geometryLiteral, (ExecutionContext)execCxt);
        }
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    private QueryIterator bothUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
        Graph graph = execCxt.getActiveGraph();
        ExtendedIterator subjectTriples = graph.find(null, RDF.type.asNode(), Geo.GEOMETRY_NODE);
        Var subjectVar = Var.alloc((String)subject.getName());
        while (subjectTriples.hasNext()) {
            Triple subjectTriple = (Triple)subjectTriples.next();
            Binding newBind = BindingFactory.binding((Binding)binding, (Var)subjectVar, (Node)subjectTriple.getSubject());
            QueryIterator queryIter = this.objectUnbound(newBind, subjectTriple.getSubject(), predicate, object, execCxt);
            queryIterConcat.add(queryIter);
        }
        return queryIterConcat;
    }
}

