/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.jena.geosparql.implementation.jts.CoordinateSequenceDimensions;
import org.apache.jena.geosparql.implementation.jts.CustomCoordinateSequence;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;

public class DimensionInfo
implements Serializable {
    private final int coordinate;
    private final int spatial;
    private final int topological;
    private final CoordinateSequenceDimensions coordinateSequenceDimensions;
    private final boolean isPoint;
    private final boolean isLine;
    private final boolean isArea;
    private static final Coordinate XY_COORDINATE = new CoordinateXY(0.0, 0.0);
    public static DimensionInfo XY_POINT = new DimensionInfo(2, 2, 0);
    public static DimensionInfo XYZ_POINT = new DimensionInfo(3, 3, 0);
    public static DimensionInfo XYM_POINT = new DimensionInfo(3, 2, 0);
    public static DimensionInfo XYZM_POINT = new DimensionInfo(4, 3, 0);
    public static DimensionInfo XY_LINESTRING = new DimensionInfo(2, 2, 1);
    public static DimensionInfo XYZ_LINESTRING = new DimensionInfo(3, 3, 1);
    public static DimensionInfo XYM_LINESTRING = new DimensionInfo(3, 2, 1);
    public static DimensionInfo XYZM_LINESTRING = new DimensionInfo(4, 3, 1);
    public static DimensionInfo XY_POLYGON = new DimensionInfo(2, 2, 2);
    public static DimensionInfo XYZ_POLYGON = new DimensionInfo(3, 3, 2);
    public static DimensionInfo XYM_POLYGON = new DimensionInfo(3, 2, 2);
    public static DimensionInfo XYZM_POLYGON = new DimensionInfo(4, 3, 2);

    public DimensionInfo(CoordinateSequenceDimensions coordinateSequenceDimensions, int topological) {
        this.coordinateSequenceDimensions = coordinateSequenceDimensions;
        this.topological = topological;
        this.coordinate = DimensionInfo.findCoordinateDimension(coordinateSequenceDimensions);
        this.spatial = DimensionInfo.findSpatialDimension(coordinateSequenceDimensions);
        this.isPoint = topological == 0;
        this.isLine = topological == 1;
        this.isArea = topological == 2;
    }

    public DimensionInfo(int coordinate, int spatial, int topological) {
        this.coordinate = coordinate;
        this.spatial = spatial;
        this.topological = topological;
        this.coordinateSequenceDimensions = CustomCoordinateSequence.findCoordinateSequenceDimensions(coordinate, spatial);
        this.isPoint = topological == 0;
        this.isLine = topological == 1;
        this.isArea = topological == 2;
    }

    public static int findSpatialDimension(CoordinateSequenceDimensions dims) {
        switch (dims) {
            case XYZ: 
            case XYZM: {
                return 3;
            }
        }
        return 2;
    }

    public static int findCoordinateDimension(CoordinateSequenceDimensions dims) {
        switch (dims) {
            case XYZ: 
            case XYM: {
                return 3;
            }
            case XYZM: {
                return 4;
            }
        }
        return 2;
    }

    public static DimensionInfo find(Coordinate coordinate, Geometry geometry) {
        CoordinateSequenceDimensions coordDims = CoordinateSequenceDimensions.find(coordinate);
        return new DimensionInfo(coordDims, geometry.getDimension());
    }

    public static DimensionInfo find(Coordinate[] coordinates, Geometry geometry) {
        Coordinate coordinate = coordinates.length == 0 ? XY_COORDINATE : coordinates[0];
        return DimensionInfo.find(coordinate, geometry);
    }

    public static DimensionInfo find(List<Coordinate> coordinates, Geometry geometry) {
        Coordinate coordinate = coordinates.isEmpty() ? XY_COORDINATE : coordinates.get(0);
        return DimensionInfo.find(coordinate, geometry);
    }

    public static DimensionInfo findCollection(List<? extends Geometry> geometries, Geometry geometry) {
        Coordinate coordinate;
        if (geometries.isEmpty()) {
            coordinate = XY_COORDINATE;
        } else {
            Geometry geom = geometries.get(0);
            coordinate = geom.getCoordinate();
        }
        return DimensionInfo.find(coordinate, geometry);
    }

    public int getCoordinate() {
        return this.coordinate;
    }

    public int getSpatial() {
        return this.spatial;
    }

    public int getTopological() {
        return this.topological;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public boolean isLine() {
        return this.isLine;
    }

    public boolean isArea() {
        return this.isArea;
    }

    public CoordinateSequenceDimensions getDimensions() {
        return this.coordinateSequenceDimensions;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.coordinate;
        hash = 53 * hash + this.spatial;
        hash = 53 * hash + this.topological;
        hash = 53 * hash + Objects.hashCode((Object)this.coordinateSequenceDimensions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionInfo other = (DimensionInfo)obj;
        if (this.coordinate != other.coordinate) {
            return false;
        }
        if (this.spatial != other.spatial) {
            return false;
        }
        if (this.topological != other.topological) {
            return false;
        }
        return this.coordinateSequenceDimensions == other.coordinateSequenceDimensions;
    }

    public String toString() {
        return "DimensionInfo{coordinate=" + this.coordinate + ", spatial=" + this.spatial + ", topological=" + this.topological + ", coordinateSequenceDimensions=" + this.coordinateSequenceDimensions + ", isPoint=" + this.isPoint + ", isLine=" + this.isLine + ", isArea=" + this.isArea + "}";
    }
}

