/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import io.github.galbiston.expiring_map.ExpiringMap;
import java.util.Map;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;

public class GeometryLiteralIndex {
    private static boolean INDEX_ACTIVE = false;
    private static final String PRIMARY_INDEX_LABEL = "Primary Geometry Literal Index";
    private static final String SECONDARY_INDEX_LABEL = "Secondary Geometry Literal Index";
    private static ExpiringMap<String, GeometryWrapper> PRIMARY_INDEX = new ExpiringMap("Primary Geometry Literal Index", -1, 5000L);
    private static ExpiringMap<String, GeometryWrapper> SECONDARY_INDEX = new ExpiringMap("Secondary Geometry Literal Index", -1, 5000L);

    public static final GeometryWrapper retrieve(String geometryLiteral, GeometryDatatype geometryDatatype, GeometryIndex targetIndex) {
        GeometryWrapper geometryWrapper;
        switch (targetIndex) {
            case SECONDARY: {
                geometryWrapper = GeometryLiteralIndex.retrieveMemoryIndex(geometryLiteral, geometryDatatype, SECONDARY_INDEX, PRIMARY_INDEX);
                break;
            }
            default: {
                geometryWrapper = GeometryLiteralIndex.retrieveMemoryIndex(geometryLiteral, geometryDatatype, PRIMARY_INDEX, SECONDARY_INDEX);
            }
        }
        return geometryWrapper;
    }

    private static GeometryWrapper retrieveMemoryIndex(String geometryLiteral, GeometryDatatype geometryDatatype, Map<String, GeometryWrapper> index, Map<String, GeometryWrapper> otherIndex) {
        if (INDEX_ACTIVE) {
            GeometryWrapper geometryWrapper;
            if (index.containsKey(geometryLiteral)) {
                geometryWrapper = index.get(geometryLiteral);
            } else {
                geometryWrapper = otherIndex.containsKey(geometryLiteral) ? otherIndex.get(geometryLiteral) : geometryDatatype.read(geometryLiteral);
                index.put(geometryLiteral, geometryWrapper);
            }
            return geometryWrapper;
        }
        return geometryDatatype.read(geometryLiteral);
    }

    public static final void clear() {
        PRIMARY_INDEX.clear();
        SECONDARY_INDEX.clear();
    }

    public static final void setMaxSize(int maxSize) {
        PRIMARY_INDEX.setMaxSize((long)maxSize);
        SECONDARY_INDEX.setMaxSize((long)maxSize);
    }

    public static final void setExpiry(long expiryInterval) {
        PRIMARY_INDEX.setExpiryInterval(expiryInterval);
        SECONDARY_INDEX.setExpiryInterval(expiryInterval);
    }

    public static final long getPrimaryIndexSize() {
        return PRIMARY_INDEX.mappingCount();
    }

    public static final long getSecondaryIndexSize() {
        return SECONDARY_INDEX.mappingCount();
    }

    public static boolean isIndexActive() {
        return INDEX_ACTIVE;
    }

    public static void setIndexActive(boolean indexActive) {
        INDEX_ACTIVE = indexActive;
        if (INDEX_ACTIVE) {
            PRIMARY_INDEX.startExpiry();
            SECONDARY_INDEX.startExpiry();
        } else {
            PRIMARY_INDEX.stopExpiry();
            SECONDARY_INDEX.stopExpiry();
        }
    }

    public static void reset(int maxSize, long expiryInterval) {
        PRIMARY_INDEX = new ExpiringMap(PRIMARY_INDEX_LABEL, maxSize, expiryInterval);
        SECONDARY_INDEX = new ExpiringMap(SECONDARY_INDEX_LABEL, maxSize, expiryInterval);
    }

    public static enum GeometryIndex {
        PRIMARY,
        SECONDARY;

    }
}

