/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.jena.geosparql.implementation.registry.UnitsURIException;
import org.apache.sis.measure.Units;

public class UnitsRegistry {
    private static final Map<String, Unit<?>> UNITS_REGISTRY = Collections.synchronizedMap(new HashMap());
    private static final Map<Unit<?>, String> UNITS_URI_REGISTRY = Collections.synchronizedMap(new HashMap());
    private static final Unit<Length> YARD = Units.METRE.multiply(1.0936132983);

    public static final void addUnit(String unitURI, Unit<?> unit) {
        UNITS_REGISTRY.putIfAbsent(unitURI, unit);
        UNITS_URI_REGISTRY.putIfAbsent(unit, unitURI);
    }

    public static final void addUnit(UnitsOfMeasure unitsOfMeasure) {
        UnitsRegistry.addUnit(unitsOfMeasure.getUnitURI(), unitsOfMeasure.getUnit());
    }

    public static final Unit<?> getUnit(String unitURI) {
        if (UNITS_REGISTRY.containsKey(unitURI)) {
            return UNITS_REGISTRY.get(unitURI);
        }
        throw new UnitsURIException("Unrecognised unit URI: " + unitURI);
    }

    public static final String getUnitURI(UnitsOfMeasure unitOfMeasure) {
        return UnitsRegistry.getUnitURI(unitOfMeasure.getUnit());
    }

    public static final String getUnitURI(Unit<?> unit) {
        if (UNITS_URI_REGISTRY.containsKey(unit)) {
            return UNITS_URI_REGISTRY.get(unit);
        }
        throw new UnitsURIException("Unrecognised unit: " + unit);
    }

    public static final Boolean isLinearUnits(String unitURI) {
        if (UNITS_REGISTRY.containsKey(unitURI)) {
            Unit<?> unit = UNITS_REGISTRY.get(unitURI);
            Unit unitSI = unit.getSystemUnit();
            return unitSI.equals(Units.METRE);
        }
        throw new UnitsURIException("Unrecognised unit URI: " + unitURI);
    }

    static {
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/meter", Units.METRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/metre", Units.METRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/kilometer", Units.KILOMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/kilometre", Units.KILOMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/centimeter", Units.CENTIMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/centimetre", Units.CENTIMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/millimeter", Units.MILLIMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/millimetre", Units.MILLIMETRE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9001", Units.METRE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9036", Units.KILOMETRE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::1033", Units.CENTIMETRE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/statuteMile", Units.STATUTE_MILE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/mile", Units.STATUTE_MILE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/yard", YARD);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/foot", Units.FOOT);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/inch", Units.INCH);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/nauticalMile", Units.NAUTICAL_MILE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/surveyFootUS", Units.US_SURVEY_FOOT);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9093", Units.STATUTE_MILE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9002", Units.FOOT);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9096", YARD);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9030", Units.NAUTICAL_MILE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9003", Units.US_SURVEY_FOOT);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/radian", Units.RADIAN);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/microRadian", Units.MICRORADIAN);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/degree", Units.DEGREE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/minute", Units.ARC_MINUTE);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/second", Units.ARC_SECOND);
        UnitsRegistry.addUnit("http://www.opengis.net/def/uom/OGC/1.0/grad", Units.GRAD);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9101", Units.RADIAN);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9109", Units.MICRORADIAN);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9102", Units.DEGREE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9103", Units.ARC_MINUTE);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9104", Units.ARC_SECOND);
        UnitsRegistry.addUnit("urn:ogc:def:uom:EPSG::9105", Units.GRAD);
    }
}

