/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase3;
import org.apache.jena.sparql.util.FmtUtils;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class TransformFF
extends FunctionBase3 {
    public NodeValue exec(NodeValue v1, NodeValue v2, NodeValue v3) {
        try {
            if (!v2.isIRI() && !v2.isString()) {
                throw new ExprEvalException("Not a URI: " + FmtUtils.stringForNode((Node)v2.asNode()));
            }
            if (!v3.isIRI() && !v3.isString()) {
                throw new ExprEvalException("Not a URI: " + FmtUtils.stringForNode((Node)v3.asNode()));
            }
            String datatypeURI = v2.isIRI() ? v2.asNode().getURI() : v2.asString();
            String srsURI = v3.isIRI() ? v3.asNode().getURI() : v3.asString();
            GeometryWrapper geometry = GeometryWrapper.extract(v1, GeometryLiteralIndex.GeometryIndex.PRIMARY);
            GeometryWrapper convertedGeom = geometry.transform(srsURI);
            Literal convertedGeomLit = convertedGeom.asLiteral(datatypeURI);
            return NodeValue.makeNode((String)convertedGeomLit.getLexicalForm(), (RDFDatatype)convertedGeomLit.getDatatype());
        }
        catch (DatatypeFormatException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

