/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions;

import java.util.Objects;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.spatial.SearchEnvelope;

public class SpatialArguments {
    protected final int limit;
    protected final GeometryWrapper geometryWrapper;
    protected final SearchEnvelope searchEnvelope;

    public SpatialArguments(int limit, GeometryWrapper geometryWrapper, SearchEnvelope searchEnvelope) {
        this.limit = limit;
        this.geometryWrapper = geometryWrapper;
        this.searchEnvelope = searchEnvelope;
    }

    public int getLimit() {
        return this.limit;
    }

    public GeometryWrapper getGeometryWrapper() {
        return this.geometryWrapper;
    }

    public SearchEnvelope getSearchEnvelope() {
        return this.searchEnvelope;
    }

    public String toString() {
        return "SpatialArguments{limit=" + this.limit + ", geometryWrapper=" + this.geometryWrapper + ", searchEnvelope=" + this.searchEnvelope + "}";
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.limit;
        hash = 53 * hash + Objects.hashCode(this.geometryWrapper);
        hash = 53 * hash + Objects.hashCode(this.searchEnvelope);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialArguments other = (SpatialArguments)obj;
        if (this.limit != other.limit) {
            return false;
        }
        if (!Objects.equals(this.geometryWrapper, other.geometryWrapper)) {
            return false;
        }
        return Objects.equals(this.searchEnvelope, other.searchEnvelope);
    }
}

