/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.nearby;

import java.util.List;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.geosparql.spatial.property_functions.nearby.NearbyGeomPF;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public class NearbyPF
extends NearbyGeomPF {
    private static final int LAT_POS = 0;
    private static final int LON_POS = 1;
    private static final int RADIUS_POS = 2;
    private static final int UNITS_POS = 3;
    private static final int LIMIT_POS = 4;
    public static final String DEFAULT_UNITS = "http://www.opengis.net/def/uom/OGC/1.0/kilometre";

    @Override
    protected SpatialArguments extractObjectArguments(Node predicate, PropFuncArg object, SRSInfo indexSRSInfo) {
        try {
            int limit;
            List objectArgs = object.getArgList();
            if (objectArgs.size() < 3) {
                throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Minimum of 3 arguments.");
            }
            if (objectArgs.size() > 5) {
                throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Maximum of 5 arguments.");
            }
            Node lat = (Node)objectArgs.get(0);
            Node lon = (Node)objectArgs.get(1);
            NodeValue radiusNode = NodeValue.makeNode((Node)((Node)objectArgs.get(2)));
            if (lat.isVariable() || lon.isVariable() || !radiusNode.isDouble()) {
                throw new ExprEvalException("Arguments are not all concrete: " + FmtUtils.stringForNode((Node)lat) + ", " + FmtUtils.stringForNode((Node)lon) + ", " + FmtUtils.stringForNode((Node)radiusNode.asNode()));
            }
            this.radius = radiusNode.getDouble();
            if (objectArgs.size() > 3) {
                Node unitsNode = (Node)objectArgs.get(3);
                if (!unitsNode.isURI()) {
                    throw new ExprEvalException("Not a URI: " + FmtUtils.stringForNode((Node)unitsNode));
                }
                this.unitsURI = unitsNode.getURI();
            } else {
                this.unitsURI = DEFAULT_UNITS;
            }
            if (objectArgs.size() > 4) {
                NodeValue limitNode = NodeValue.makeNode((Node)((Node)objectArgs.get(4)));
                if (!limitNode.isInteger()) {
                    throw new ExprEvalException("Not an integer: " + FmtUtils.stringForNode((Node)limitNode.getNode()));
                }
                limit = limitNode.getInteger().intValue();
            } else {
                limit = -1;
            }
            GeometryWrapper geometryWrapper = ConvertLatLon.toGeometryWrapper(lat, lon);
            SearchEnvelope searchEnvelope = SearchEnvelope.build(geometryWrapper, indexSRSInfo, this.radius, this.unitsURI);
            return new SpatialArguments(limit, geometryWrapper, searchEnvelope);
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
    }
}

