/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KMeans$
implements ScalaObject,
Serializable {
    public static final KMeans$ MODULE$;
    private final String RANDOM;
    private final String K_MEANS_PARALLEL;

    static {
        new KMeans$();
    }

    public String RANDOM() {
        return this.RANDOM;
    }

    public String K_MEANS_PARALLEL() {
        return this.K_MEANS_PARALLEL;
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs, String initializationMode) {
        return new KMeans().setK(k).setMaxIterations(maxIterations).setRuns(runs).setInitializationMode(initializationMode).run(data);
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs) {
        return this.train(data, k, maxIterations, runs, this.K_MEANS_PARALLEL());
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations) {
        return this.train(data, k, maxIterations, 1, this.K_MEANS_PARALLEL());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Object> findClosest(double[][] centers$2, double[] point$2) {
        void $inlThis1;
        DoubleRef bestDistance$1 = new DoubleRef(Double.POSITIVE_INFINITY);
        IntRef bestIndex$1 = new IntRef(0);
        int n = centers$2.length;
        RichInt richInt = new RichInt(0);
        Range range = Range$.MODULE$.apply(richInt.self(), n);
        if (range.length() <= 0) return new Tuple2.mcID.sp(bestIndex$1.elem, bestDistance$1.elem);
        int n2 = $inlThis1.last();
        int n3 = $inlThis1.start();
        while (true) {
            if (n3 == n2) {
                void v11;
                int n4 = n3;
                double distance1 = MLUtils$.MODULE$.squaredDistance(point$2, centers$2[n4]);
                if (!(distance1 < bestDistance$1.elem)) return new Tuple2.mcID.sp(bestIndex$1.elem, bestDistance$1.elem);
                bestDistance$1.elem = distance1;
                bestIndex$1.elem = v11;
                return new Tuple2.mcID.sp(bestIndex$1.elem, bestDistance$1.elem);
            }
            int n5 = n3;
            double distance2 = MLUtils$.MODULE$.squaredDistance(point$2, centers$2[n5]);
            if (distance2 < bestDistance$1.elem) {
                void v12;
                bestDistance$1.elem = distance2;
                bestIndex$1.elem = v12;
            }
            n3 += $inlThis1.step();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double pointCost(double[][] centers$4, double[] point$4) {
        void $inlThis1;
        DoubleRef bestDistance$2 = new DoubleRef(Double.POSITIVE_INFINITY);
        int n = centers$4.length;
        RichInt richInt = new RichInt(0);
        Range range = Range$.MODULE$.apply(richInt.self(), n);
        if (range.length() <= 0) return bestDistance$2.elem;
        int n2 = $inlThis1.last();
        int n3 = $inlThis1.start();
        while (true) {
            if (n3 == n2) {
                int n4 = n3;
                double distance1 = MLUtils$.MODULE$.squaredDistance(point$4, centers$4[n4]);
                if (!(distance1 < bestDistance$2.elem)) return bestDistance$2.elem;
                bestDistance$2.elem = distance1;
                return bestDistance$2.elem;
            }
            int n5 = n3;
            double distance2 = MLUtils$.MODULE$.squaredDistance(point$4, centers$4[n5]);
            if (distance2 < bestDistance$2.elem) {
                bestDistance$2.elem = distance2;
            }
            n3 += $inlThis1.step();
        }
    }

    public void main(String[] args) {
        Tuple4 tuple4;
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"Usage: KMeans <master> <input_file> <k> <max_iterations> [<runs>]");
            System.exit(1);
        }
        if ((tuple4 = new Tuple4((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[2]).toInt()), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[3]).toInt()))) != null) {
            Tuple4 tuple42 = new Tuple4(tuple4._1(), tuple4._2(), tuple4._3(), tuple4._4());
            String master = (String)tuple42._1();
            String inputFile = (String)tuple42._2();
            int k = BoxesRunTime.unboxToInt((Object)tuple42._3());
            int iters = BoxesRunTime.unboxToInt((Object)tuple42._4());
            int runs = args.length >= 5 ? Predef$.MODULE$.augmentString(args[4]).toInt() : 1;
            SparkContext sc = new SparkContext(master, "KMeans", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
            RDD data = sc.textFile(inputFile, sc.textFile$default$2()).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final double[] apply(String line) {
                    return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(line).split(' ')).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final double apply(String string) {
                            return Predef$.MODULE$.augmentString(string).toDouble();
                        }
                    }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double()));
                }
            }, ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double())).cache();
            KMeansModel model = this.train((RDD<double[]>)data, k, iters, runs);
            double cost = model.computeCost((RDD<double[]>)data);
            Predef$.MODULE$.println((Object)"Cluster centers:");
            Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(double[] c) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"  ").append((Object)Predef$.MODULE$.doubleArrayOps(c).mkString(" ")).toString());
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cost: ").append((Object)BoxesRunTime.boxToDouble((double)cost)).toString());
            System.exit(0);
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private KMeans$() {
        MODULE$ = this;
        this.RANDOM = "random";
        this.K_MEANS_PARALLEL = "k-means||";
    }
}

