/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredGradient;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.ScalaObject;
import scala.Serializable;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u00015\u0011q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f+m\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005i9UM\\3sC2L'0\u001a3MS:,\u0017M]!mO>\u0014\u0018\u000e\u001e5n!\ty1#\u0003\u0002\u0015\u0005\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\f\u001d\u0013\tirCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0001\u0011\u0002\u0011M$X\r]*ju\u0016,\u0012!\t\t\u0003-\tJ!aI\f\u0003\r\u0011{WO\u00197f\u0011!)\u0003A!a\u0001\n\u00031\u0013\u0001D:uKB\u001c\u0016N_3`I\u0015\fHCA\u0014+!\t1\u0002&\u0003\u0002*/\t!QK\\5u\u0011\u001dYC%!AA\u0002\u0005\n1\u0001\u001f\u00132\u0011!i\u0003A!A!B\u0013\t\u0013!C:uKB\u001c\u0016N_3!\u0011!y\u0003A!a\u0001\n\u0003\u0001\u0014!\u00048v[&#XM]1uS>t7/F\u00012!\t1\"'\u0003\u00024/\t\u0019\u0011J\u001c;\t\u0011U\u0002!\u00111A\u0005\u0002Y\n\u0011C\\;n\u0013R,'/\u0019;j_:\u001cx\fJ3r)\t9s\u0007C\u0004,i\u0005\u0005\t\u0019A\u0019\t\u0011e\u0002!\u0011!Q!\nE\naB\\;n\u0013R,'/\u0019;j_:\u001c\b\u0005\u0003\u0005<\u0001\t\u0005\r\u0011\"\u0001!\u0003Ei\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u0005\t{\u0001\u0011\t\u0019!C\u0001}\u0005)R.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8`I\u0015\fHCA\u0014@\u0011\u001dYC(!AA\u0002\u0005B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006K!I\u0001\u0013[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0005C\u0003D\u0001\u0011%A)\u0001\u0004=S:LGO\u0010\u000b\u0005\u000b\u001a;\u0005\n\u0005\u0002\u0010\u0001!)qD\u0011a\u0001C!)qF\u0011a\u0001c!)1H\u0011a\u0001C!9!\n\u0001b\u0001\n\u0003Y\u0015\u0001C4sC\u0012LWM\u001c;\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005Es%aD*rk\u0006\u0014X\rZ$sC\u0012LWM\u001c;\t\rM\u0003\u0001\u0015!\u0003M\u0003%9'/\u00193jK:$\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0001,\u0002\u000fU\u0004H-\u0019;feV\tq\u000b\u0005\u0002N1&\u0011\u0011L\u0014\u0002\u000e'&l\u0007\u000f\\3Va\u0012\fG/\u001a:\t\rm\u0003\u0001\u0015!\u0003X\u0003!)\b\u000fZ1uKJ\u0004\u0003bB/\u0001\u0005\u0004%\tAX\u0001\n_B$\u0018.\\5{KJ,\u0012a\u0018\t\u0003\u001b\u0002L!!\u0019(\u0003\u001f\u001d\u0013\u0018\rZ5f]R$Um]2f]RDaa\u0019\u0001!\u0002\u0013y\u0016AC8qi&l\u0017N_3sA!)1\t\u0001C\u0001KR\tQ\tC\u0003h\u0001\u0011\u0005\u0001.A\u0006de\u0016\fG/Z'pI\u0016dGc\u0001\nj]\")!N\u001aa\u0001W\u00069q/Z5hQR\u001c\bc\u0001\fmC%\u0011Qn\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006_\u001a\u0004\r!I\u0001\nS:$XM]2faR<Q!\u001d\u0002\t\u0006I\fq\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u0011\u0005=\u0019h!B\u0001\u0003\u0011\u000b!8\u0003B:v7U\u0001\"A^>\u000e\u0003]T!\u0001_=\u0002\t1\fgn\u001a\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0004PE*,7\r\u001e\u0005\u0006\u0007N$\tA \u000b\u0002e\"9\u0011\u0011A:\u0005\u0002\u0005\r\u0011!\u0002;sC&tGc\u0003\n\u0002\u0006\u0005m\u0011QDA\u0010\u0003CAq!a\u0002\u0000\u0001\u0004\tI!A\u0003j]B,H\u000f\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003'\tiAA\u0002S\t\u0012\u00032aDA\f\u0013\r\tIB\u0001\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006_}\u0004\r!\r\u0005\u0006?}\u0004\r!\t\u0005\u0006w}\u0004\r!\t\u0005\u0007\u0003Gy\b\u0019A6\u0002\u001d%t\u0017\u000e^5bY^+\u0017n\u001a5ug\"9\u0011\u0011A:\u0005\u0002\u0005\u001dB#\u0003\n\u0002*\u0005-\u0012QFA\u0018\u0011!\t9!!\nA\u0002\u0005%\u0001BB\u0018\u0002&\u0001\u0007\u0011\u0007\u0003\u0004 \u0003K\u0001\r!\t\u0005\u0007w\u0005\u0015\u0002\u0019A\u0011\t\u000f\u0005\u00051\u000f\"\u0001\u00024Q9!#!\u000e\u00028\u0005e\u0002\u0002CA\u0004\u0003c\u0001\r!!\u0003\t\r=\n\t\u00041\u00012\u0011\u0019y\u0012\u0011\u0007a\u0001C!9\u0011\u0011A:\u0005\u0002\u0005uB#\u0002\n\u0002@\u0005\u0005\u0003\u0002CA\u0004\u0003w\u0001\r!!\u0003\t\r=\nY\u00041\u00012\u0011\u001d\t)e\u001dC\u0001\u0003\u000f\nA!\\1j]R\u0019q%!\u0013\t\u0011\u0005-\u00131\ta\u0001\u0003\u001b\nA!\u0019:hgB!a\u0003\\A(!\u0011\t\t&a\u0016\u000f\u0007Y\t\u0019&C\u0002\u0002V]\ta\u0001\u0015:fI\u00164\u0017\u0002BA-\u00037\u0012aa\u0015;sS:<'bAA+/!9\u0011qL:\u0005\u0012\u0005\u0005\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012!\u001e")
public class LinearRegressionWithSGD
extends GeneralizedLinearAlgorithm<LinearRegressionModel>
implements Serializable,
ScalaObject {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private final SquaredGradient gradient;
    private final SimpleUpdater updater;
    private final GradientDescent optimizer;

    public static final void main(String[] stringArray) {
        LinearRegressionWithSGD$.MODULE$.main(stringArray);
    }

    public static final LinearRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static final LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d);
    }

    public static final LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static final LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double[] dArray) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, dArray);
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double d) {
        this.stepSize = d;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int n) {
        this.numIterations = n;
    }

    public double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    public void miniBatchFraction_$eq(double d) {
        this.miniBatchFraction = d;
    }

    public SquaredGradient gradient() {
        return this.gradient;
    }

    public SimpleUpdater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public LinearRegressionModel createModel(double[] weights, double intercept) {
        return new LinearRegressionModel(weights, intercept);
    }

    public LinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new SquaredGradient();
        this.updater = new SimpleUpdater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public LinearRegressionWithSGD() {
        this(1.0, 100, 1.0);
    }
}

