/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.util.KMeansDataGenerator$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KMeansDataGenerator$
implements ScalaObject {
    public static final KMeansDataGenerator$ MODULE$;

    static {
        new KMeansDataGenerator$();
    }

    public RDD<double[]> generateKMeansRDD(SparkContext sc, int numPoints, int k$1, int d$1, double r$1, int numPartitions) {
        Random rand$1 = new Random(42);
        double[][] centers$1 = (double[][])Array$.MODULE$.fill(k$1, (Function0)new Serializable(d$1, r$1, rand$1){
            public static final long serialVersionUID;
            public final int d$1;
            public final double r$1;
            public final Random rand$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(this.d$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    public final anonfun.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply() {
                        return this.$outer.rand$1.nextGaussian() * this.$outer.r$1;
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rand$1.nextGaussian() * this.$outer.r$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (ClassManifest)Manifest$.MODULE$.Double());
            }
            {
                this.d$1 = n;
                this.r$1 = d;
                this.rand$1 = random;
            }
        }, ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double()));
        return sc.parallelize((Seq)Predef$.MODULE$.intWrapper(0).until(numPoints), numPartitions, (ClassManifest)Manifest$.MODULE$.Int()).map((Function1)new Serializable(k$1, d$1, centers$1){
            public static final long serialVersionUID;
            public final int k$1;
            public final int d$1;
            public final double[][] centers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double[] apply(int idx) {
                double[] center$1 = this.centers$1[idx % this.k$1];
                Random rand2$1 = new Random(42 + idx);
                return (double[])Array$.MODULE$.tabulate(this.d$1, (Function1)new Serializable(this, center$1, rand2$1){
                    public static final long serialVersionUID;
                    public final double[] center$1;
                    public final Random rand2$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(int i) {
                        int n = i;
                        return this.center$1[n] + this.rand2$1.nextGaussian();
                    }

                    public double apply$mcDI$sp(int v1) {
                        return this.center$1[v1] + this.rand2$1.nextGaussian();
                    }
                    {
                        this.center$1 = dArray;
                        this.rand2$1 = random;
                    }
                }, (ClassManifest)Manifest$.MODULE$.Double());
            }
            {
                this.k$1 = n;
                this.d$1 = n2;
                this.centers$1 = dArray;
            }
        }, ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double()));
    }

    public int generateKMeansRDD$default$6() {
        return 2;
    }

    public void main(String[] args) {
        if (args.length < 6) {
            Predef$.MODULE$.println((Object)"Usage: KMeansGenerator <master> <output_dir> <num_points> <k> <d> <r> [<num_partitions>]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int numPoints = Predef$.MODULE$.augmentString(args[2]).toInt();
        int k = Predef$.MODULE$.augmentString(args[3]).toInt();
        int d = Predef$.MODULE$.augmentString(args[4]).toInt();
        double r = Predef$.MODULE$.augmentString(args[5]).toDouble();
        int parts = args.length >= 7 ? Predef$.MODULE$.augmentString(args[6]).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "KMeansDataGenerator", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
        RDD<double[]> data = this.generateKMeansRDD(sc, numPoints, k, d, r, parts);
        data.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(double[] dArray) {
                return Predef$.MODULE$.doubleArrayOps(dArray).mkString(" ");
            }
        }, ClassManifest$.MODULE$.classType(String.class)).saveAsTextFile(outputPath);
        System.exit(0);
    }

    private KMeansDataGenerator$() {
        MODULE$ = this;
    }
}

