/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import java.io.Serializable;
import net.sf.acegisecurity.GrantedAuthority;

public class User
implements Serializable {
    private String password;
    private String username;
    private GrantedAuthority[] authorities;
    private boolean enabled;

    public User(String username, String password, boolean enabled, GrantedAuthority[] authorities) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null || "".equals(password) || authorities == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (authorities[i] != null) continue;
            throw new IllegalArgumentException("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.authorities = authorities;
    }

    protected User() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }
}

