/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.activecluster.Cluster;
import org.activecluster.Node;

public class ClusterEvent
implements Externalizable {
    public static final int ADD_NODE = 1;
    public static final int UPDATE_NODE = 2;
    public static final int REMOVE_NODE = 3;
    public static final int FAILED_NODE = 4;
    public static final int ELECTED_COORDINATOR = 5;
    private transient Cluster cluster;
    private Node node;
    private int type;

    public ClusterEvent() {
    }

    public ClusterEvent(Cluster source, Node node, int type) {
        this.cluster = source;
        this.node = node;
        this.type = type;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster source) {
        this.cluster = source;
    }

    public Node getNode() {
        return this.node;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "ClusterEvent[" + this.getTypeAsString() + " : " + this.node + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeObject(this.node);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.node = (Node)in.readObject();
    }

    private String getTypeAsString() {
        String result = "unknown type";
        if (this.type == 1) {
            result = "ADD_NODE";
        } else if (this.type == 3) {
            result = "REMOVE_NODE";
        } else if (this.type == 2) {
            result = "UPDATE_NODE";
        } else if (this.type == 4) {
            result = "FAILED_NODE";
        }
        return result;
    }
}

