/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.group;

import java.util.ArrayList;
import java.util.List;
import org.activecluster.Node;

public class Group {
    private int minimumMemberCount;
    private int maximumMemberCount;
    private List members = new ArrayList();
    private int memberCount;

    public Group() {
    }

    public Group(int minimumMemberCount, int maximumMemberCount) {
        this.minimumMemberCount = minimumMemberCount;
        this.maximumMemberCount = maximumMemberCount;
    }

    public synchronized List getMembers() {
        return new ArrayList(this.members);
    }

    public synchronized int addMember(Node node) {
        int index = this.members.indexOf(node);
        if (index >= 0) {
            return index;
        }
        this.members.add(node);
        return this.memberCount++;
    }

    public synchronized boolean removeMember(Node node) {
        boolean answer = this.members.remove(node);
        if (answer) {
            --this.memberCount;
        }
        return answer;
    }

    public boolean isUsable() {
        return this.memberCount >= this.minimumMemberCount;
    }

    public boolean isFull() {
        return this.memberCount >= this.maximumMemberCount;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int getMaximumMemberCount() {
        return this.maximumMemberCount;
    }

    public void setMaximumMemberCount(int maximumMemberCount) {
        this.maximumMemberCount = maximumMemberCount;
    }

    public int getMinimumMemberCount() {
        return this.minimumMemberCount;
    }

    public void setMinimumMemberCount(int minimumMemberCount) {
        this.minimumMemberCount = minimumMemberCount;
    }
}

