/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activecluster.Node;
import org.activecluster.group.Group;
import org.activecluster.group.NodeFilter;
import org.activecluster.group.NodeMemberships;

public class GroupModel {
    private int maximumGroups = -1;
    private int minimumMemberCount = 2;
    private int maximumMemberCount = 3;
    private List groups = new ArrayList();
    private LinkedList incompleteGroups = new LinkedList();
    private LinkedList completeGroups = new LinkedList();
    private LinkedList fullGroups = new LinkedList();
    private LinkedList unusedNodes = new LinkedList();
    private NodeFilter masterFilter;
    private Map nodeMemberships = new HashMap();
    private int maximumWeighting = 10;

    public synchronized void addNode(Node node) {
        if (!this.addToExistingGroup(node)) {
            Group group = this.makeNewGroup(node);
            if (group == null) {
                this.addToUnusedNodes(node);
            } else {
                this.addGroup(group);
            }
        }
    }

    public synchronized void removeNode(Node node) {
        this.unusedNodes.remove(node);
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            boolean wasFull = group.isFull();
            boolean wasUsable = group.isUsable();
            if (!this.removeNodeFromGroup(group, node)) continue;
            this.updateGroupCollections(group, wasFull, wasUsable);
        }
    }

    public synchronized List getGroups() {
        return new ArrayList(this.groups);
    }

    public NodeFilter getMasterFilter() {
        return this.masterFilter;
    }

    public void setMasterFilter(NodeFilter masterFilter) {
        this.masterFilter = masterFilter;
    }

    public int getMaximumGroups() {
        return this.maximumGroups;
    }

    public void setMaximumGroups(int maximumGroups) {
        this.maximumGroups = maximumGroups;
    }

    public int getMaximumMemberCount() {
        return this.maximumMemberCount;
    }

    public void setMaximumMemberCount(int maximumMemberCount) {
        this.maximumMemberCount = maximumMemberCount;
    }

    public int getMinimumMemberCount() {
        return this.minimumMemberCount;
    }

    public void setMinimumMemberCount(int minimumMemberCount) {
        this.minimumMemberCount = minimumMemberCount;
    }

    public int getMaximumWeighting() {
        return this.maximumWeighting;
    }

    public void setMaximumWeighting(int maximumWeighting) {
        this.maximumWeighting = maximumWeighting;
    }

    protected Group makeNewGroup(Node node) {
        if (this.canCreateGroup(node)) {
            Group group = this.createGroup(node);
            this.addNodeToGroup(group, node);
            return group;
        }
        return null;
    }

    protected void tryToFillGroupWithBuddies(Group group) {
        boolean continueFillingGroups = true;
        while (!group.isUsable() && continueFillingGroups) {
            continueFillingGroups = this.tryToAddBuddy(group);
        }
        if (continueFillingGroups) {
            Iterator iter = new ArrayList(this.incompleteGroups).iterator();
            while (iter.hasNext() && continueFillingGroups) {
                group = (Group)iter.next();
                boolean wasFull = group.isFull();
                boolean wasUsable = group.isUsable();
                while (!group.isUsable() && continueFillingGroups) {
                    continueFillingGroups = this.tryToAddBuddy(group);
                }
                if (!group.isUsable()) continue;
                this.updateGroupCollections(group, wasFull, wasUsable);
            }
        }
    }

    protected boolean tryToAddBuddy(Group group) {
        boolean continueFillingGroups = true;
        NodeMemberships lowest = null;
        int lowestWeight = 0;
        Iterator iter = this.nodeMemberships.values().iterator();
        while (iter.hasNext()) {
            NodeMemberships memberships = (NodeMemberships)iter.next();
            if (memberships.isMember(group)) continue;
            int weighting = memberships.getWeighting();
            if (lowest != null && weighting >= lowestWeight || weighting >= this.maximumWeighting) continue;
            lowest = memberships;
            lowestWeight = weighting;
        }
        if (lowest == null) {
            continueFillingGroups = false;
        } else {
            this.addNodeToGroup(group, lowest.getNode());
        }
        return continueFillingGroups;
    }

    protected void updateGroupCollections(Group group, boolean wasFull, boolean wasUsable) {
        boolean full = group.isFull();
        if (wasFull && !full) {
            this.fullGroups.remove(group);
        }
        boolean usable = group.isUsable();
        if (wasUsable && !usable) {
            this.completeGroups.remove(group);
        }
        if (!(usable && full || !wasFull && !wasUsable)) {
            this.incompleteGroups.add(group);
        }
    }

    protected void addToUnusedNodes(Node node) {
        this.unusedNodes.add(node);
    }

    protected boolean addToExistingGroup(Node node) {
        return this.addToIncompleteGroup(node) || this.addToNotFullGroup(node);
    }

    protected boolean addToNotFullGroup(Node node) {
        return this.addToPendingGroup(this.completeGroups, node);
    }

    protected boolean addToIncompleteGroup(Node node) {
        return this.addToPendingGroup(this.incompleteGroups, node);
    }

    protected boolean addToPendingGroup(LinkedList list, Node node) {
        if (!list.isEmpty()) {
            Group group = (Group)list.getFirst();
            this.addNodeToGroup(group, node);
            if (group.isFull()) {
                list.removeFirst();
                this.fullGroups.add(group);
            } else if (group.isUsable()) {
                list.removeFirst();
                this.completeGroups.add(group);
            }
            return true;
        }
        return false;
    }

    protected void addNodeToGroup(Group group, Node node) {
        NodeMemberships memberships = (NodeMemberships)this.nodeMemberships.get(node);
        if (memberships == null) {
            memberships = new NodeMemberships(node);
            this.nodeMemberships.put(node, memberships);
        }
        memberships.addToGroup(group);
    }

    protected boolean removeNodeFromGroup(Group group, Node node) {
        NodeMemberships memberships = (NodeMemberships)this.nodeMemberships.get(node);
        if (memberships != null) {
            return memberships.removeFromGroup(group);
        }
        return false;
    }

    protected void addGroup(Group group) {
        this.groups.add(group);
        if (group.isFull()) {
            this.fullGroups.add(group);
        } else if (group.isUsable()) {
            this.completeGroups.add(group);
        } else {
            this.incompleteGroups.add(group);
        }
    }

    protected Group createGroup(Node node) {
        return new Group(this.minimumMemberCount, this.maximumMemberCount);
    }

    protected boolean canCreateGroup(Node node) {
        return (this.maximumGroups < 0 || this.groups.size() < this.maximumGroups) && this.canBeMaster(node);
    }

    protected boolean canBeMaster(Node node) {
        return this.masterFilter == null || this.masterFilter.evaluate(node);
    }
}

