/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.group;

import java.util.HashMap;
import java.util.Map;
import org.activecluster.Node;
import org.activecluster.group.Group;
import org.activecluster.group.Membership;

public class NodeMemberships {
    private Node node;
    private Map memberships = new HashMap();
    private int weighting;

    public NodeMemberships(Node node) {
        this.node = node;
    }

    public void addToGroup(Group group) {
        if (!this.isMember(group)) {
            int index = group.addMember(this.node);
            Membership membership = new Membership(group, index);
            this.memberships.put(group, membership);
            this.weighting += membership.getWeighting();
        }
    }

    public boolean removeFromGroup(Group group) {
        this.memberships.remove(group);
        return group.removeMember(this.node);
    }

    public Node getNode() {
        return this.node;
    }

    public int getWeighting() {
        return this.weighting;
    }

    public boolean isMember(Group group) {
        return this.memberships.containsKey(group);
    }
}

