/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.Serializable;
import java.util.Map;
import java.util.Timer;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.activecluster.Cluster;
import org.activecluster.ClusterListener;
import org.activecluster.LocalNode;
import org.activecluster.Service;
import org.activecluster.impl.ReplicatedLocalNode;
import org.activecluster.impl.StateConsumer;
import org.activecluster.impl.StateServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCluster
implements Cluster {
    private static final Log log = LogFactory.getLog((Class)DefaultCluster.class);
    private StateServiceImpl stateService;
    private LocalNode localNode;
    private Topic destination;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Timer timer;
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Object clusterLock = new Object();

    public DefaultCluster(final LocalNode localNode, Topic dataTopic, Topic destination, Connection connection, Session session, MessageProducer producer, Timer timer, long inactiveTime) throws JMSException {
        this.localNode = localNode;
        this.destination = destination;
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.timer = timer;
        if (producer == null) {
            throw new IllegalArgumentException("No producer specified!");
        }
        this.consumer = session.createConsumer((Destination)dataTopic, null, true);
        log.info((Object)("Creating data consumer on topic: " + dataTopic));
        this.stateService = new StateServiceImpl(this, this.clusterLock, new Runnable(){

            public void run() {
                if (localNode instanceof ReplicatedLocalNode) {
                    ((ReplicatedLocalNode)localNode).pingRemoteNodes();
                }
            }
        }, timer, inactiveTime);
        this.consumer.setMessageListener((MessageListener)new StateConsumer(this.stateService));
    }

    public synchronized void addClusterListener(ClusterListener listener) {
        this.stateService.addClusterListener(listener);
    }

    public synchronized void removeClusterListener(ClusterListener listener) {
        this.stateService.removeClusterListener(listener);
    }

    public Topic getDestination() {
        return this.destination;
    }

    public LocalNode getLocalNode() {
        return this.localNode;
    }

    public Map getNodes() {
        return this.stateService.getNodes();
    }

    public synchronized void send(Destination destination, Message message) throws JMSException {
        this.producer.send(destination, message);
    }

    public synchronized MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.getSession().createConsumer(destination, selector);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.getSession().createConsumer(destination, selector, noLocal);
    }

    public synchronized Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public synchronized BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public synchronized ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getSession().createObjectMessage(object);
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public synchronized TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public synchronized void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.connection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        try {
            if (this.localNode instanceof Service) {
                ((Service)((Object)this.localNode)).stop();
            }
            this.timer.cancel();
            this.session.close();
            this.connection.stop();
            this.connection.close();
        }
        finally {
            this.connection = null;
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForClusterToComplete(int expectedCount, long timeout) throws InterruptedException {
        long waitTime = timeout = timeout > 0L ? timeout : Long.MAX_VALUE;
        long start = System.currentTimeMillis();
        Object object = this.clusterLock;
        synchronized (object) {
            while (this.stateService.getNodes().size() < expectedCount && this.started.get() && waitTime > 0L) {
                this.clusterLock.wait(waitTime);
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
        }
        return this.stateService.getNodes().size() >= expectedCount;
    }

    protected Session getSession() throws JMSException {
        if (this.session == null) {
            throw new JMSException("Cannot perform operation, this cluster connection is now closed");
        }
        return this.session;
    }
}

