/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.impl;

import java.util.Timer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.activecluster.Cluster;
import org.activecluster.ClusterException;
import org.activecluster.ClusterFactory;
import org.activecluster.impl.DefaultCluster;
import org.activecluster.impl.ReplicatedLocalNode;
import org.activecluster.impl.StateServiceStub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultClusterFactory
implements ClusterFactory {
    private static final Log log = LogFactory.getLog((Class)DefaultClusterFactory.class);
    private ConnectionFactory connectionFactory;
    private boolean transacted;
    private int acknowledgeMode;
    private String dataTopicPrefix;
    private long inactiveTime;
    private boolean useQueueForInbox = false;
    private int deliveryMode = 1;

    public DefaultClusterFactory(ConnectionFactory connectionFactory, boolean transacted, int acknowledgeMode, String dataTopicPrefix, long inactiveTime) {
        this.connectionFactory = connectionFactory;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.dataTopicPrefix = dataTopicPrefix;
        this.inactiveTime = inactiveTime;
    }

    public DefaultClusterFactory(ConnectionFactory connectionFactory) {
        this(connectionFactory, false, 1, "ACTIVECLUSTER.DATA.", 5000L);
    }

    public Cluster createCluster(Topic groupDestination) throws ClusterException, JMSException {
        Connection connection = this.getConnectionFactory().createConnection();
        Session session = this.createSession(connection);
        return this.createCluster(connection, session, groupDestination);
    }

    public Cluster createCluster(String topic) throws ClusterException, JMSException {
        Connection connection = this.getConnectionFactory().createConnection();
        Session session = this.createSession(connection);
        Topic groupDestination = session.createTopic(topic);
        return this.createCluster(connection, session, groupDestination);
    }

    public String getDataTopicPrefix() {
        return this.dataTopicPrefix;
    }

    public void setDataTopicPrefix(String dataTopicPrefix) {
        this.dataTopicPrefix = dataTopicPrefix;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public long getInactiveTime() {
        return this.inactiveTime;
    }

    public void setInactiveTime(long inactiveTime) {
        this.inactiveTime = inactiveTime;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isUseQueueForInbox() {
        return this.useQueueForInbox;
    }

    public void setUseQueueForInbox(boolean useQueueForInbox) {
        this.useQueueForInbox = useQueueForInbox;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    protected Cluster createCluster(Connection connection, Session session, Topic groupDestination) throws JMSException {
        Topic dataTopic = session.createTopic(this.dataTopicPrefix + groupDestination.getTopicName());
        log.info((Object)("Creating cluster group producer on topic: " + groupDestination));
        MessageProducer producer = this.createProducer(session, null);
        producer.setDeliveryMode(this.deliveryMode);
        log.info((Object)("Creating cluster data producer on topic: " + dataTopic));
        MessageProducer keepAliveProducer = session.createProducer((Destination)dataTopic);
        keepAliveProducer.setDeliveryMode(1);
        StateServiceStub serviceStub = new StateServiceStub(session, keepAliveProducer);
        Object localInbox = null;
        localInbox = this.useQueueForInbox ? session.createTemporaryQueue() : session.createTemporaryTopic();
        ReplicatedLocalNode localNode = new ReplicatedLocalNode((Destination)localInbox, serviceStub);
        Timer timer = new Timer();
        DefaultCluster answer = new DefaultCluster(localNode, dataTopic, groupDestination, connection, session, producer, timer, this.inactiveTime);
        return answer;
    }

    protected MessageProducer createProducer(Session session, Topic groupDestination) throws JMSException {
        return session.createProducer((Destination)groupDestination);
    }

    protected Session createSession(Connection connection) throws JMSException {
        return connection.createSession(this.transacted, this.acknowledgeMode);
    }
}

