/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.impl;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.activecluster.Node;
import org.activecluster.impl.StateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateConsumer
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)StateConsumer.class);
    private StateService stateService;

    public StateConsumer(StateService stateService) {
        if (stateService == null) {
            throw new IllegalArgumentException("Must specify a valid StateService implementation");
        }
        this.stateService = stateService;
    }

    public void onMessage(Message message) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received cluster data message!: " + message));
            }
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                try {
                    Node node = (Node)objectMessage.getObject();
                    String type = objectMessage.getJMSType();
                    if (type != null && type.equals("shutdown")) {
                        this.stateService.shutdown(node);
                        break block6;
                    }
                    this.stateService.keepAlive(node);
                }
                catch (Exception e) {
                    log.error((Object)("Could not extract node from message: " + e + ". Message: " + message), (Throwable)e);
                }
            } else {
                log.warn((Object)("Ignoring message: " + message));
            }
        }
    }
}

