/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.activecluster.Cluster;
import org.activecluster.ClusterEvent;
import org.activecluster.ClusterListener;
import org.activecluster.Node;
import org.activecluster.election.ElectionStrategy;
import org.activecluster.election.impl.BullyElectionStrategy;
import org.activecluster.impl.NodeImpl;
import org.activecluster.impl.StateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateServiceImpl
implements StateService {
    private static final Log log = LogFactory.getLog((Class)StateServiceImpl.class);
    private Cluster cluster;
    private Object clusterLock;
    private Map nodes = new HashMap();
    private long inactiveTime;
    private List listeners = Collections.synchronizedList(new ArrayList());
    private Destination localDestination;
    private Runnable localNodePing;
    private Timer timer;
    private NodeImpl coordinator;
    private ElectionStrategy electionStrategy;

    public StateServiceImpl(Cluster cluster, Object clusterLock, Runnable localNodePing, Timer timer, long inactiveTime) {
        this.cluster = cluster;
        this.clusterLock = clusterLock;
        this.localDestination = cluster.getLocalNode().getDestination();
        this.localNodePing = localNodePing;
        this.timer = timer;
        this.inactiveTime = inactiveTime;
        long delay = inactiveTime / 3L;
        timer.scheduleAtFixedRate(this.createTimerTask(), delay, delay);
        this.coordinator = (NodeImpl)((Object)cluster.getLocalNode());
        this.coordinator.setCoordinator(true);
        this.electionStrategy = new BullyElectionStrategy();
    }

    public ElectionStrategy getElectionStrategy() {
        return this.electionStrategy;
    }

    public void setElectionStrategy(ElectionStrategy electionStrategy) {
        this.electionStrategy = electionStrategy;
    }

    public long getInactiveTime() {
        return this.inactiveTime;
    }

    public void setInactiveTime(long inactiveTime) {
        this.inactiveTime = inactiveTime;
    }

    public synchronized Map getNodes() {
        HashMap<Destination, Node> answer = new HashMap<Destination, Node>(this.nodes.size());
        Iterator iter = this.nodes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Destination key = (Destination)entry.getKey();
            NodeEntry nodeEntry = (NodeEntry)entry.getValue();
            answer.put(key, nodeEntry.node);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void keepAlive(Node node) {
        Destination key = node.getDestination();
        if (!this.localDestination.equals(key)) {
            NodeEntry entry = (NodeEntry)this.nodes.get(key);
            if (entry == null) {
                entry = new NodeEntry();
                entry.node = node;
                this.nodes.put(key, entry);
                this.nodeAdded(node);
                Object object = this.clusterLock;
                synchronized (object) {
                    this.clusterLock.notifyAll();
                }
            } else if (this.stateHasChanged(entry.node, node)) {
                entry.node = node;
                this.nodeUpdated(node);
            }
            entry.lastKeepAlive = this.getTimeMillis();
        }
    }

    public synchronized void shutdown(Node node) {
        Destination key = node.getDestination();
        this.nodes.remove(key);
        ClusterEvent event = new ClusterEvent(this.cluster, node, 1);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeRemoved(event);
        }
    }

    public synchronized void checkForTimeouts() {
        this.localNodePing.run();
        long time = this.getTimeMillis();
        Iterator iter = this.nodes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            NodeEntry nodeEntry = (NodeEntry)entry.getValue();
            if (nodeEntry.lastKeepAlive + this.inactiveTime >= time) continue;
            iter.remove();
            this.nodeFailed(nodeEntry.node);
        }
    }

    public TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                StateServiceImpl.this.checkForTimeouts();
            }
        };
    }

    public void addClusterListener(ClusterListener listener) {
        this.listeners.add(listener);
    }

    public void removeClusterListener(ClusterListener listener) {
        this.listeners.remove(listener);
    }

    protected void nodeAdded(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 1);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeAdd(event);
        }
        this.doElection();
    }

    protected void nodeUpdated(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 2);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeUpdate(event);
        }
    }

    protected void nodeFailed(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 3);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeFailed(event);
        }
        this.doElection();
    }

    protected void coordinatorChanged(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 5);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onCoordinatorChanged(event);
        }
    }

    protected void doElection() {
        if (this.electionStrategy != null) {
            try {
                NodeImpl newElected = (NodeImpl)this.electionStrategy.doElection(this.cluster);
                if (newElected != null && !newElected.equals(this.coordinator)) {
                    this.coordinator.setCoordinator(false);
                    this.coordinator = newElected;
                    this.coordinator.setCoordinator(true);
                    this.coordinatorChanged(this.coordinator);
                }
            }
            catch (JMSException jmsEx) {
                log.error((Object)"do election failed", (Throwable)jmsEx);
            }
        }
    }

    protected long getTimeMillis() {
        return System.currentTimeMillis();
    }

    protected boolean stateHasChanged(Node oldNode, Node newNode) {
        Map newState;
        Map oldState = oldNode.getState();
        if (oldState == (newState = newNode.getState())) {
            return false;
        }
        return oldState == null || newState == null || !((Object)oldState).equals(newState);
    }

    protected static class NodeEntry {
        public Node node;
        public long lastKeepAlive;

        protected NodeEntry() {
        }
    }
}

