/*
 * Decompiled with CFR 0.152.
 */
package org.activecluster.impl;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.activecluster.Node;
import org.activecluster.impl.NodeImpl;
import org.activecluster.impl.StateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateServiceStub
implements StateService {
    private final Log log = LogFactory.getLog(this.getClass());
    private Session session;
    private MessageProducer producer;

    public StateServiceStub(Session session, MessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    public void keepAlive(Node node) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending cluster data message: " + node));
            }
            ObjectMessage message = this.session.createObjectMessage((Serializable)new NodeImpl(node));
            this.producer.send((Message)message);
        }
        catch (JMSException e) {
            this.log.error((Object)("Could not send JMS message: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void shutdown(Node node) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending shutdown message: " + node));
            }
            ObjectMessage message = this.session.createObjectMessage((Serializable)new NodeImpl(node));
            message.setJMSType("shutdown");
            this.producer.send((Message)message);
        }
        catch (JMSException e) {
            this.log.error((Object)("Could not send JMS message: " + (Object)((Object)e)), (Throwable)e);
        }
    }
}

