/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activecluster.impl;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.codehaus.activecluster.Cluster;
import org.codehaus.activecluster.ClusterException;
import org.codehaus.activecluster.ClusterFactory;
import org.codehaus.activecluster.impl.DefaultCluster;
import org.codehaus.activecluster.impl.ReplicatedLocalNode;
import org.codehaus.activecluster.impl.StateServiceStub;

public class DefaultClusterFactory
implements ClusterFactory {
    private Connection connection;
    private boolean transacted;
    private int acknowledgeMode;
    private String dataTopicPrefix;

    public DefaultClusterFactory(Connection connection, boolean transacted, int acknowledgeMode, String dataTopicPrefix) {
        this.connection = connection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.dataTopicPrefix = dataTopicPrefix;
    }

    public DefaultClusterFactory(Connection connection) {
        this(connection, false, 1, "ACTIVECLUSTER.DATA.");
    }

    public Cluster createCluster(Topic groupDestination) throws ClusterException, JMSException {
        Session session = this.createSession();
        MessageProducer producer = this.createProducer(session);
        Topic dataTopic = session.createTopic(this.dataTopicPrefix + groupDestination.getTopicName());
        MessageConsumer dataConsumer = session.createConsumer((Destination)dataTopic);
        StateServiceStub serviceStub = new StateServiceStub(session, session.createProducer((Destination)dataTopic));
        return new DefaultCluster(new ReplicatedLocalNode(serviceStub), dataTopic, groupDestination, this.connection, session, producer);
    }

    protected MessageProducer createProducer(Session session) {
        return null;
    }

    protected Session createSession() throws JMSException {
        return this.connection.createSession(this.transacted, this.acknowledgeMode);
    }
}

