/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activecluster.impl;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activecluster.Node;
import org.codehaus.activecluster.impl.StateService;

public class StateConsumer
implements MessageListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private StateService stateService;

    public StateConsumer(StateService stateService) {
        this.stateService = stateService;
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                Node node = (Node)((Object)objectMessage.getObject());
                this.stateService.keepAlive(node);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not extract node from message: " + e + ". Message: " + message), (Throwable)e);
            }
        } else {
            this.log.warn((Object)("Ignoring message: " + message));
        }
    }
}

